/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXClippedPane;
import com.jfoenix.controls.JFXColorPicker;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.controls.behavior.JFXColorPickerBehavior;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.skins.JFXColorPalette;
import com.jfoenix.skins.JFXColorPickerSkin$$Lambda$1;
import com.jfoenix.skins.JFXColorPickerSkin$$Lambda$2;
import com.jfoenix.skins.JFXColorPickerSkin$$Lambda$3;
import com.jfoenix.utils.JFXNodeUtils;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class JFXColorPickerSkin
extends ComboBoxPopupControl<Color> {
    private Label displayNode;
    private JFXClippedPane colorBox;
    private JFXColorPalette popupContent;
    StyleableBooleanProperty colorLabelVisible = new SimpleStyleableBooleanProperty(StyleableProperties.access$000(), (Object)this, "colorLabelVisible", true);

    public JFXColorPickerSkin(ColorPicker colorPicker) {
        super((ComboBoxBase)colorPicker, (ComboBoxBaseBehavior)new JFXColorPickerBehavior(colorPicker));
        this.displayNode = new Label("");
        this.displayNode.getStyleClass().add((Object)"color-label");
        this.displayNode.setMouseTransparent(true);
        this.colorBox = new JFXClippedPane(new Node[]{this.displayNode});
        this.colorBox.getStyleClass().add((Object)"color-box");
        this.colorBox.setManaged(false);
        this.initColor();
        JFXRippler rippler = new JFXRippler((Node)this.colorBox, JFXRippler.RipplerMask.FIT);
        rippler.ripplerFillProperty().bind((ObservableValue)this.displayNode.textFillProperty());
        this.getChildren().setAll((Object[])new Node[]{rippler});
        JFXDepthManager.setDepth((Node)this.getSkinnable(), 1);
        ((ComboBoxBase)this.getSkinnable()).setPickOnBounds(false);
        colorPicker.focusedProperty().addListener(JFXColorPickerSkin$$Lambda$1.lambdaFactory$(this, colorPicker, rippler));
        this.registerChangeListener((ObservableValue)colorPicker.valueProperty(), "VALUE");
        this.colorLabelVisible.addListener(JFXColorPickerSkin$$Lambda$2.lambdaFactory$(this));
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double width = 100.0;
        String displayNodeText = this.displayNode.getText();
        this.displayNode.setText("#DDDDDD");
        width = Math.max(width, super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset));
        this.displayNode.setText(displayNodeText);
        return width + rightInset + leftInset;
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.colorBox == null) {
            this.updateDisplayArea();
        }
        return topInset + this.colorBox.prefHeight(width) + bottomInset;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double hInsets = this.snappedLeftInset() + this.snappedRightInset();
        double vInsets = this.snappedTopInset() + this.snappedBottomInset();
        double width = w + hInsets;
        double height = h + vInsets;
        this.colorBox.resizeRelocate(0.0, 0.0, width, height);
    }

    protected Node getPopupContent() {
        if (this.popupContent == null) {
            this.popupContent = new JFXColorPalette((JFXColorPicker)this.getSkinnable());
            this.popupContent.setPopupControl(this.getPopup());
        }
        return this.popupContent;
    }

    protected void focusLost() {
    }

    public void show() {
        super.show();
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        this.popupContent.updateSelection((Color)colorPicker.getValue());
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("SHOWING".equals(p)) {
            if (((ComboBoxBase)this.getSkinnable()).isShowing()) {
                this.show();
            } else if (!this.popupContent.isCustomColorDialogShowing()) {
                this.hide();
            }
        } else if ("VALUE".equals(p)) {
            this.updateColor();
        }
    }

    public Node getDisplayNode() {
        return this.displayNode;
    }

    private void updateColor() {
        Color circleColor;
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        Color color = (Color)colorPicker.getValue();
        Color color2 = circleColor = color == null ? Color.WHITE : color;
        if (((JFXColorPicker)this.getSkinnable()).isDisableAnimation().booleanValue()) {
            JFXNodeUtils.updateBackground(this.colorBox.getBackground(), (Region)this.colorBox, (Paint)circleColor);
        } else {
            Circle colorCircle = new Circle();
            colorCircle.setFill((Paint)circleColor);
            colorCircle.setManaged(false);
            colorCircle.setLayoutX(this.colorBox.getWidth() / 4.0);
            colorCircle.setLayoutY(this.colorBox.getHeight() / 2.0);
            this.colorBox.getChildren().add((Object)colorCircle);
            Timeline animateColor = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)colorCircle.radiusProperty(), (Object)200, Interpolator.EASE_BOTH)})});
            animateColor.setOnFinished(JFXColorPickerSkin$$Lambda$3.lambdaFactory$(this, colorCircle));
            animateColor.play();
        }
        this.displayNode.setTextFill((Paint)(circleColor.grayscale().getRed() < 0.5 ? Color.valueOf((String)"rgba(255, 255, 255, 0.87)") : Color.valueOf((String)"rgba(0, 0, 0, 0.87)")));
        if (this.colorLabelVisible.get()) {
            this.displayNode.setText(JFXNodeUtils.colorToHex(circleColor));
        } else {
            this.displayNode.setText("");
        }
    }

    private void initColor() {
        ColorPicker colorPicker = (ColorPicker)this.getSkinnable();
        Color color = (Color)colorPicker.getValue();
        Color circleColor = color == null ? Color.WHITE : color;
        this.colorBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)circleColor, new CornerRadii(3.0), Insets.EMPTY)}));
        this.displayNode.setTextFill((Paint)(circleColor.grayscale().getRed() < 0.5 ? Color.valueOf((String)"rgba(255, 255, 255, 0.87)") : Color.valueOf((String)"rgba(0, 0, 0, 0.87)")));
        if (this.colorLabelVisible.get()) {
            this.displayNode.setText(JFXNodeUtils.colorToHex(circleColor));
        } else {
            this.displayNode.setText("");
        }
    }

    public void syncWithAutoUpdate() {
        if (!this.getPopup().isShowing() && ((ComboBoxBase)this.getSkinnable()).isShowing()) {
            ((ComboBoxBase)this.getSkinnable()).hide();
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return JFXColorPickerSkin.getClassCssMetaData();
    }

    protected TextField getEditor() {
        return null;
    }

    protected StringConverter<Color> getConverter() {
        return null;
    }

    static /* synthetic */ void lambda$updateColor$2(JFXColorPickerSkin this_, Circle colorCircle, ActionEvent finish) {
        JFXNodeUtils.updateBackground(this_.colorBox.getBackground(), (Region)this_.colorBox, colorCircle.getFill());
        this_.colorBox.getChildren().remove((Object)colorCircle);
    }

    static /* synthetic */ void lambda$new$1(JFXColorPickerSkin this_, Observable invalidate) {
        if (this_.displayNode != null) {
            if (this_.colorLabelVisible.get()) {
                this_.displayNode.setText(JFXNodeUtils.colorToHex((Color)((ComboBoxBase)this_.getSkinnable()).getValue()));
            } else {
                this_.displayNode.setText("");
            }
        }
    }

    static /* synthetic */ void lambda$new$0(JFXColorPickerSkin this_, ColorPicker colorPicker, JFXRippler rippler, Observable observable) {
        if (colorPicker.isFocused()) {
            if (!((ComboBoxBase)this_.getSkinnable()).isPressed()) {
                rippler.setOverlayVisible(true);
            }
        } else {
            rippler.setOverlayVisible(false);
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<ColorPicker, Boolean> COLOR_LABEL_VISIBLE = new CssMetaData<ColorPicker, Boolean>("-fx-color-label-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            public boolean isSettable(ColorPicker n) {
                JFXColorPickerSkin skin = (JFXColorPickerSkin)n.getSkin();
                return skin.colorLabelVisible == null || !skin.colorLabelVisible.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(ColorPicker n) {
                JFXColorPickerSkin skin = (JFXColorPickerSkin)n.getSkin();
                return skin.colorLabelVisible;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return COLOR_LABEL_VISIBLE;
        }

        static {
            ArrayList<CssMetaData<ColorPicker, Boolean>> styleables = new ArrayList<CssMetaData<ColorPicker, Boolean>>(ComboBoxPopupControl.getClassCssMetaData());
            styleables.add(COLOR_LABEL_VISIBLE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

