/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.pannable.gestures;

import com.jfoenix.controls.pannable.base.IPannablePane;
import com.jfoenix.controls.pannable.gestures.PanningGestures$$Lambda$1;
import com.jfoenix.controls.pannable.gestures.PanningGestures$$Lambda$2;
import com.jfoenix.controls.pannable.gestures.PanningGestures$$Lambda$3;
import com.jfoenix.controls.pannable.gestures.PanningGestures$$Lambda$4;
import com.jfoenix.controls.pannable.gestures.PanningGestures$$Lambda$5;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class PanningGestures<T extends Node> {
    private T canvas;
    private final DragContext sceneDragContext = new DragContext();
    private final DoubleProperty minScaleProperty = new SimpleDoubleProperty(0.1);
    private final DoubleProperty maxScaleProperty = new SimpleDoubleProperty(10.0);
    private final DoubleProperty zoomSpeedProperty = new SimpleDoubleProperty(1.2);
    private SimpleBooleanProperty useViewportGestures = null;
    private boolean bound = false;
    private final EventHandler<MouseEvent> onMousePressedEventHandler = PanningGestures$$Lambda$1.lambdaFactory$(this);
    private final EventHandler<MouseEvent> onMouseDraggedEventHandler = PanningGestures$$Lambda$2.lambdaFactory$(this);
    private final EventHandler<ScrollEvent> onScrollEventHandler = PanningGestures$$Lambda$3.lambdaFactory$(this);

    public PanningGestures(T canvas) {
        this.canvas = canvas;
    }

    public double getMinScale() {
        return this.minScaleProperty.get();
    }

    public void setMinScale(double minScale) {
        this.minScaleProperty.set(minScale);
    }

    public DoubleProperty minScaleProperty() {
        return this.minScaleProperty;
    }

    public double getMaxScale() {
        return this.maxScaleProperty.get();
    }

    public DoubleProperty maxScaleProperty() {
        return this.maxScaleProperty;
    }

    public void setMaxScale(double maxScale) {
        this.maxScaleProperty.set(maxScale);
    }

    public double getZoomSpeed() {
        return this.zoomSpeedProperty.get();
    }

    public DoubleProperty zoomSpeedProperty() {
        return this.zoomSpeedProperty;
    }

    public void setZoomSpeed(double zoomSpeed) {
        this.zoomSpeedProperty.set(zoomSpeed);
    }

    public final BooleanProperty useViewPortGesturesProperty() {
        return this.useViewportGestures;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }

    private double bound(double newTrans, double parentSize, double canvasSize) {
        if (!this.bound) {
            return newTrans;
        }
        double lowerBound = parentSize - canvasSize - 20.0 * ((IPannablePane)this.canvas).getScale();
        newTrans = parentSize > canvasSize ? 1.0 : this.inBound(lowerBound, 1.0, newTrans);
        return newTrans;
    }

    private double inBound(double lowerBound, double upperBound, double val) {
        if (val < lowerBound) {
            val = lowerBound;
        } else if (val > upperBound) {
            val = upperBound;
        }
        return val;
    }

    public static double clamp(double value, double min, double max) {
        if (Double.compare(value, min) < 0) {
            return min;
        }
        if (Double.compare(value, max) > 0) {
            return max;
        }
        return value;
    }

    public static <T extends Node> PanningGestures<T> attachViewPortGestures(T pannableCanvas) {
        return PanningGestures.attachViewPortGestures(pannableCanvas, false);
    }

    public static <T extends Node> PanningGestures<T> attachViewPortGestures(T pannableCanvas, boolean configurable) {
        PanningGestures<T> panningGestures = new PanningGestures<T>(pannableCanvas);
        if (configurable) {
            panningGestures.useViewportGestures = new SimpleBooleanProperty(true);
            panningGestures.useViewportGestures.addListener(PanningGestures$$Lambda$4.lambdaFactory$(pannableCanvas, panningGestures));
        }
        pannableCanvas.parentProperty().addListener(PanningGestures$$Lambda$5.lambdaFactory$(panningGestures));
        return panningGestures;
    }

    static /* synthetic */ void lambda$attachViewPortGestures$4(PanningGestures panningGestures, ObservableValue o, Parent oldVal, Parent newVal) {
        if (oldVal != null) {
            oldVal.removeEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
            oldVal.removeEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
            oldVal.removeEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
        }
        if (newVal != null) {
            newVal.addEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
            newVal.addEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
            newVal.addEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
        }
    }

    static /* synthetic */ void lambda$attachViewPortGestures$3(Node pannableCanvas, PanningGestures panningGestures, ObservableValue o, Boolean oldVal, Boolean newVal) {
        Parent parent = (Parent)pannableCanvas.parentProperty().get();
        if (parent == null) {
            return;
        }
        if (newVal.booleanValue()) {
            parent.addEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
            parent.addEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
            parent.addEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
        } else {
            parent.removeEventHandler(MouseEvent.MOUSE_PRESSED, panningGestures.onMousePressedEventHandler);
            parent.removeEventHandler(MouseEvent.MOUSE_DRAGGED, panningGestures.onMouseDraggedEventHandler);
            parent.removeEventHandler(ScrollEvent.ANY, panningGestures.onScrollEventHandler);
        }
    }

    static /* synthetic */ void lambda$new$2(PanningGestures this_, ScrollEvent event) {
        double scale = ((IPannablePane)this_.canvas).getScale();
        scale = event.getDeltaY() < 0.0 ? (scale /= this_.getZoomSpeed()) : (scale *= this_.getZoomSpeed());
        scale = PanningGestures.clamp(scale, this_.minScaleProperty.get(), this_.maxScaleProperty.get());
        Point2D currentPoint = this_.canvas.parentToLocal(event.getX(), event.getY());
        ((IPannablePane)this_.canvas).setScale(scale);
        Point2D newPoint = this_.canvas.localToParent(currentPoint);
        Bounds parentLayoutBounds = this_.canvas.getParent().getLayoutBounds();
        Bounds boundsInParent = this_.canvas.getBoundsInParent();
        double lowerBound = parentLayoutBounds.getWidth() - boundsInParent.getWidth() - 20.0;
        this_.canvas.setTranslateX(this_.bound(this_.canvas.getTranslateX() - (newPoint.getX() - event.getX()), parentLayoutBounds.getWidth(), boundsInParent.getWidth()));
        this_.canvas.setTranslateY(this_.bound(this_.canvas.getTranslateY() - (newPoint.getY() - event.getY()), parentLayoutBounds.getHeight(), boundsInParent.getHeight()));
        event.consume();
    }

    static /* synthetic */ void lambda$new$1(PanningGestures this_, MouseEvent event) {
        if (!event.isSecondaryButtonDown()) {
            return;
        }
        Bounds parentLayoutBounds = this_.canvas.getParent().getLayoutBounds();
        Bounds boundsInParent = this_.canvas.getBoundsInParent();
        double newTransX = this_.sceneDragContext.translateAnchorX + event.getSceneX() - this_.sceneDragContext.mouseAnchorX;
        this_.canvas.setTranslateX(this_.bound(newTransX, parentLayoutBounds.getWidth(), boundsInParent.getWidth()));
        double newTransY = this_.sceneDragContext.translateAnchorY + event.getSceneY() - this_.sceneDragContext.mouseAnchorY;
        this_.canvas.setTranslateY(this_.bound(newTransY, parentLayoutBounds.getHeight(), boundsInParent.getHeight()));
        event.consume();
    }

    static /* synthetic */ void lambda$new$0(PanningGestures this_, MouseEvent event) {
        if (!event.isSecondaryButtonDown()) {
            return;
        }
        this_.sceneDragContext.mouseAnchorX = event.getSceneX();
        this_.sceneDragContext.mouseAnchorY = event.getSceneY();
        this_.sceneDragContext.translateAnchorX = this_.canvas.getTranslateX();
        this_.sceneDragContext.translateAnchorY = this_.canvas.getTranslateY();
    }

    private static class DragContext {
        double mouseAnchorX;
        double mouseAnchorY;
        double translateAnchorX;
        double translateAnchorY;

        private DragContext() {
        }
    }
}

