/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.pannable.base;

import com.jfoenix.controls.pannable.base.IObservableObject;
import com.jfoenix.controls.pannable.base.ResilientObservable$$Lambda$1;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ResilientObservable<L>
implements IObservableObject<L> {
    private CopyOnWriteArrayList<WeakObject<L>> listeners = new CopyOnWriteArrayList();

    @Override
    public boolean addListener(L observer) {
        return this.listeners.add(new WeakObject(observer));
    }

    @Override
    public boolean removeListener(L observer) {
        return this.listeners.remove(new WeakObject(observer));
    }

    public void fireEvent(Consumer<L> listenerConsumer) {
        ArrayList<WeakObject<L>> toBeRemoved = new ArrayList<WeakObject<L>>();
        for (WeakObject<L> ref : this.listeners) {
            try {
                Object listener = ref.get();
                if (listener != null) {
                    listenerConsumer.accept(listener);
                    continue;
                }
                toBeRemoved.add(ref);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                toBeRemoved.add(ref);
            }
        }
        this.listeners.removeAll(toBeRemoved);
    }

    public Collection<L> listeners() {
        return Collections.unmodifiableCollection(this.listeners.stream().map(ResilientObservable$$Lambda$1.lambdaFactory$()).collect(Collectors.toList()));
    }

    private static class WeakObject<T>
    extends WeakReference<T> {
        private WeakObject(T referent) {
            super(referent);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WeakObject)) {
                return false;
            }
            return ((WeakObject)obj).get() == this.get();
        }
    }
}

