/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXScrollPane;
import com.jfoenix.controls.JFXTreeViewPath$$Lambda$1;
import com.jfoenix.controls.JFXTreeViewPath$$Lambda$2;
import com.jfoenix.controls.JFXTreeViewPath$$Lambda$3;
import com.jfoenix.controls.JFXTreeViewPath$$Lambda$4;
import com.jfoenix.controls.JFXTreeViewPath$$Lambda$5;
import com.jfoenix.controls.JFXTreeViewPath$$Lambda$6;
import com.jfoenix.svg.SVGGlyph;
import com.jfoenix.utils.JFXNodeUtils;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;

public class JFXTreeViewPath
extends ScrollPane {
    private PseudoClass firstClass = PseudoClass.getPseudoClass((String)"first");
    private PseudoClass nextClass = PseudoClass.getPseudoClass((String)"next");
    private PseudoClass lastClass = PseudoClass.getPseudoClass((String)"last");
    private Region clip = new Region();
    private HBox container = new HBox();
    private double lastX;
    private static final String DEFAULT_STYLE_CLASS = "jfx-tree-view-path";
    private StyleableDoubleProperty offset = new SimpleStyleableDoubleProperty(StyleableProperties.access$000(), (Object)this, "offset", Double.valueOf(10.0));

    public JFXTreeViewPath(TreeView<?> treeView) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setClip((Node)this.clip);
        this.clip.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, new CornerRadii(3.0), Insets.EMPTY)}));
        this.backgroundProperty().addListener(JFXTreeViewPath$$Lambda$1.lambdaFactory$(this));
        this.container.getStyleClass().add((Object)"buttons-container");
        this.container.getChildren().add((Object)new Label("Selection Path..."));
        this.container.setAlignment(Pos.CENTER_LEFT);
        this.container.widthProperty().addListener(JFXTreeViewPath$$Lambda$2.lambdaFactory$(this));
        this.setContent((Node)this.container);
        this.setPannable(true);
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setFitToHeight(true);
        treeView.getSelectionModel().selectedItemProperty().addListener(JFXTreeViewPath$$Lambda$3.lambdaFactory$(this, treeView));
        this.container.addEventFilter(MouseEvent.MOUSE_PRESSED, JFXTreeViewPath$$Lambda$4.lambdaFactory$(this));
        this.container.addEventFilter(MouseEvent.MOUSE_DRAGGED, JFXTreeViewPath$$Lambda$5.lambdaFactory$(this));
        JFXScrollPane.smoothHScrolling(this);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.clip.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-tree-view-path.css").toExternalForm();
    }

    protected double computeMinHeight(double width) {
        return super.computePrefHeight(width);
    }

    private JFXButton createNextButton(TreeItem temp) {
        return new JFXButton(temp.getValue().toString()){
            {
                this.setPadding(new Insets(JFXTreeViewPath.this.getOffset(), 1.5 * JFXTreeViewPath.this.getOffset(), JFXTreeViewPath.this.getOffset(), 2.0 * JFXTreeViewPath.this.getOffset()));
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            }

            protected void layoutChildren() {
                super.layoutChildren();
                double width = this.getWidth();
                Polygon polygon = new Polygon();
                double height = this.getHeight();
                polygon.getPoints().addAll((Object[])new Double[]{0.0, 0.0, width - JFXTreeViewPath.this.getOffset(), 0.0, width, height / 2.0, width - JFXTreeViewPath.this.getOffset(), height, 0.0, height, JFXTreeViewPath.this.getOffset(), height / 2.0});
                this.setClip((Node)polygon);
            }
        };
    }

    public JFXButton createFirstButton(TreeItem temp) {
        return new JFXButton(temp.getValue().toString()){
            {
                this.setPadding(new Insets(JFXTreeViewPath.this.getOffset(), 1.5 * JFXTreeViewPath.this.getOffset(), JFXTreeViewPath.this.getOffset(), JFXTreeViewPath.this.getOffset()));
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            }

            protected void layoutChildren() {
                super.layoutChildren();
                double width = this.getWidth();
                Polygon polygon = new Polygon();
                double height = this.getHeight();
                polygon.getPoints().addAll((Object[])new Double[]{0.0, 0.0, width - JFXTreeViewPath.this.getOffset(), 0.0, width, height / 2.0, width - JFXTreeViewPath.this.getOffset(), height, 0.0, height});
                this.setClip((Node)polygon);
            }
        };
    }

    private JFXButton createLastButton(TreeItem temp, final TreeItem parent) {
        return new JFXButton(temp.getValue().toString()){
            private boolean noParent;
            {
                super(text);
                this.noParent = parent == null;
                this.setPadding(new Insets(JFXTreeViewPath.this.getOffset(), JFXTreeViewPath.this.getOffset(), JFXTreeViewPath.this.getOffset(), (double)(this.noParent ? 1 : 2) * JFXTreeViewPath.this.getOffset()));
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
            }

            protected void layoutChildren() {
                super.layoutChildren();
                double width = this.getWidth();
                Polygon polygon = new Polygon();
                double height = this.getHeight();
                polygon.getPoints().addAll((Object[])new Double[]{0.0, 0.0, width, 0.0, width, height, 0.0, height, this.noParent ? 0.0 : JFXTreeViewPath.this.getOffset(), this.noParent ? 0.0 : height / 2.0});
                this.setClip((Node)polygon);
            }
        };
    }

    public double getOffset() {
        return this.offset.get();
    }

    public StyleableDoubleProperty offsetProperty() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset.set(offset);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXTreeViewPath.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    static /* synthetic */ void lambda$new$5(JFXTreeViewPath this_, MouseEvent event) {
        double dx = this_.lastX - event.getX();
        if (Math.abs(dx) > 0.5) {
            double newHVal = this_.getHvalue() + dx / this_.container.getWidth();
            this_.setHvalue(newHVal);
        }
    }

    static /* synthetic */ void lambda$new$4(JFXTreeViewPath this_, MouseEvent event) {
        this_.lastX = event.getX();
    }

    static /* synthetic */ void lambda$new$3(JFXTreeViewPath this_, TreeView treeView, Observable observable) {
        TreeItem temp;
        int level = treeView.getTreeItemLevel(temp) - (treeView.isShowRoot() ? 0 : 1);
        if (temp != null) {
            TreeItem selectedItem;
            ArrayList<StackPane> newPath = new ArrayList<StackPane>();
            for (temp = selectedItem = (TreeItem)treeView.getSelectionModel().getSelectedItem(); temp != null; temp = temp.getParent()) {
                TreeItem parent;
                TreeItem treeItem = parent = treeView.isShowRoot() ? temp : temp.getParent();
                if (parent == null) continue;
                JFXButton button = null;
                if (temp.isLeaf()) {
                    button = this_.createLastButton(temp, parent.getParent());
                    button.pseudoClassStateChanged(this_.lastClass, true);
                } else if (parent.getParent() == null) {
                    button = this_.createFirstButton(temp);
                    button.pseudoClassStateChanged(this_.firstClass, true);
                } else {
                    button = this_.createNextButton(temp);
                    button.pseudoClassStateChanged(this_.nextClass, true);
                }
                TreeItem node = temp;
                button.setOnAction(JFXTreeViewPath$$Lambda$6.lambdaFactory$(treeView, node));
                StackPane container = new StackPane(new Node[]{button});
                container.setPickOnBounds(false);
                if (parent.getParent() != null) {
                    container.setTranslateX((-this_.getOffset() - 1.0) * (double)level--);
                }
                if (temp != selectedItem) {
                    SVGGlyph arrow = new SVGGlyph("M366 698l196-196-196-196 60-60 256 256-256 256z", (Paint)Color.BLACK);
                    arrow.setSizeForWidth(6.0);
                    arrow.setMouseTransparent(true);
                    StackPane.setAlignment((Node)arrow, (Pos)Pos.CENTER_RIGHT);
                    container.getChildren().add((Object)arrow);
                }
                newPath.add(0, container);
            }
            this_.container.getChildren().setAll(newPath);
        }
    }

    static /* synthetic */ void lambda$null$2(TreeView treeView, TreeItem node, ActionEvent action) {
        treeView.scrollTo(treeView.getRow(node));
    }

    static /* synthetic */ void lambda$new$1(JFXTreeViewPath this_, Observable observable) {
        this_.setHvalue(this_.getHmax());
    }

    static /* synthetic */ void lambda$new$0(JFXTreeViewPath this_, Observable observable) {
        JFXNodeUtils.updateBackground(this_.getBackground(), this_.clip);
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXTreeViewPath, Number> OFFSET = new CssMetaData<JFXTreeViewPath, Number>("-jfx-offset", SizeConverter.getInstance(), (Number)10.0){

            public boolean isSettable(JFXTreeViewPath control) {
                return control.offset == null || !control.offset.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(JFXTreeViewPath control) {
                return control.offsetProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return OFFSET;
        }

        static {
            ArrayList styleables = new ArrayList(ScrollPane.getClassCssMetaData());
            Collections.addAll(styleables, OFFSET);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

