/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXTooltip$$Lambda$1;
import com.jfoenix.controls.JFXTooltip$$Lambda$2;
import com.jfoenix.controls.JFXTooltip$$Lambda$3;
import com.jfoenix.controls.JFXTooltip$$Lambda$4;
import com.jfoenix.controls.JFXTooltip$$Lambda$5;
import com.jfoenix.controls.JFXTooltip$$Lambda$6;
import com.jfoenix.controls.JFXTooltip$$Lambda$7;
import com.jfoenix.controls.JFXTooltip$$Lambda$8;
import com.jfoenix.controls.JFXTooltip$$Lambda$9;
import com.jfoenix.controls.JFXTooltip$TooltipBehavior$$Lambda$1;
import com.jfoenix.controls.JFXTooltip$TooltipBehavior$$Lambda$2;
import com.jfoenix.controls.JFXTooltip$TooltipBehavior$$Lambda$3;
import com.jfoenix.controls.JFXTooltip$TooltipBehavior$$Lambda$4;
import com.jfoenix.controls.JFXTooltip$TooltipBehavior$$Lambda$5;
import com.jfoenix.controls.JFXTooltip$TooltipBehavior$$Lambda$6;
import com.jfoenix.controls.JFXTooltip$TooltipBehavior$$Lambda$7;
import com.jfoenix.controls.JFXTooltip$TooltipBehavior$$Lambda$8;
import com.jfoenix.transitions.JFXAnimationTimer;
import com.jfoenix.transitions.JFXKeyFrame;
import com.jfoenix.transitions.JFXKeyValue;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.scene.control.skin.TooltipSkin;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;

public class JFXTooltip
extends Tooltip {
    private static TooltipBehavior BEHAVIOR = new TooltipBehavior(Duration.millis((double)650.0), Duration.millis((double)1500.0), Duration.millis((double)200.0));
    private Node root = null;
    private boolean hiding = false;
    private JFXAnimationTimer animation = new JFXAnimationTimer(JFXKeyFrame.builder().setDuration(Duration.millis((double)150.0)).setAnimateCondition(JFXTooltip$$Lambda$1.lambdaFactory$(this)).setKeyValues(JFXKeyValue.builder().setTargetSupplier(JFXTooltip$$Lambda$2.lambdaFactory$(this)).setEndValue(1).build(), JFXKeyValue.builder().setTargetSupplier(JFXTooltip$$Lambda$3.lambdaFactory$(this)).setEndValue(1).build(), JFXKeyValue.builder().setTargetSupplier(JFXTooltip$$Lambda$4.lambdaFactory$(this)).setEndValue(1).build()).build(), JFXKeyFrame.builder().setDuration(Duration.millis((double)75.0)).setAnimateCondition(JFXTooltip$$Lambda$5.lambdaFactory$(this)).setKeyValues(JFXKeyValue.builder().setTargetSupplier(JFXTooltip$$Lambda$6.lambdaFactory$(this)).setEndValue(0).build()).build());
    private Pos pos = Pos.BOTTOM_CENTER;
    private double margin = 8.0;
    private static final String DEFAULT_STYLE_CLASS = "jfx-tooltip";
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);

    public static void setHoverDelay(Duration duration) {
        JFXTooltip.BEHAVIOR.setHoverDelay(duration == null ? Duration.millis((double)650.0) : duration);
    }

    public static void setVisibleDuration(Duration duration) {
        JFXTooltip.BEHAVIOR.setVisibleDuration(duration == null ? Duration.millis((double)1500.0) : duration);
    }

    public static void setLeftDelay(Duration duration) {
        JFXTooltip.BEHAVIOR.setLeftDelay(duration == null ? Duration.millis((double)200.0) : duration);
    }

    public static void install(Node node, JFXTooltip tooltip) {
        JFXTooltip.BEHAVIOR.install(node, tooltip);
    }

    public static void install(Node node, JFXTooltip tooltip, Pos pos) {
        tooltip.setPos(pos);
        JFXTooltip.BEHAVIOR.install(node, tooltip);
    }

    public static void uninstall(Node node) {
        JFXTooltip.BEHAVIOR.uninstall(node);
    }

    public JFXTooltip() {
        this(null);
    }

    public JFXTooltip(String text, Pos pos) {
        this(text);
        this.setPos(pos);
    }

    public JFXTooltip(String text) {
        super(text);
        this.init();
    }

    private void init() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.eventHandlerManager.addEventHandler(WindowEvent.WINDOW_SHOWING, JFXTooltip$$Lambda$7.lambdaFactory$(this));
        this.eventHandlerManager.addEventHandler(WindowEvent.WINDOW_SHOWN, JFXTooltip$$Lambda$8.lambdaFactory$(this));
    }

    public Pos getPos() {
        return this.pos;
    }

    public void setPos(Pos pos) {
        this.pos = pos == null ? Pos.BOTTOM_CENTER : pos;
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    private double getUpdatedAnchorY(double anchor) {
        switch (this.pos.getVpos()) {
            case CENTER: {
                return anchor - this.getHeight() / 2.0;
            }
            case TOP: 
            case BASELINE: {
                return anchor - this.getHeight();
            }
        }
        return anchor;
    }

    private double getUpdatedAnchorX(double anchor) {
        switch (this.pos.getHpos()) {
            case CENTER: {
                return anchor - this.getWidth() / 2.0;
            }
            case LEFT: {
                return anchor - this.getWidth();
            }
        }
        return anchor;
    }

    public void hide() {
        this.hiding = true;
        this.animation.setOnFinished(JFXTooltip$$Lambda$9.lambdaFactory$(this));
        this.animation.reverseAndContinue();
    }

    public void show(Node ownerNode, double anchorX, double anchorY) {
        this.hiding = false;
        Bounds sceneBounds = ownerNode.localToScene(ownerNode.getBoundsInLocal());
        if (this.isShowing()) {
            this.animation.setOnFinished(null);
            this.animation.reverseAndContinue();
            anchorX = this.ownerX(ownerNode, sceneBounds) + this.getHPosForNode(sceneBounds);
            anchorY = this.ownerY(ownerNode, sceneBounds) + this.getVPosForNode(sceneBounds);
            this.setAnchorY(this.getUpdatedAnchorY(anchorY));
            this.setAnchorX(this.getUpdatedAnchorX(anchorX));
        } else {
            anchorX = this.ownerX(ownerNode, sceneBounds) + this.getHPosForNode(sceneBounds);
            anchorY = this.ownerY(ownerNode, sceneBounds) + this.getVPosForNode(sceneBounds);
            super.show(ownerNode, anchorX, anchorY);
        }
    }

    private double ownerX(Node ownerNode, Bounds sceneBounds) {
        Window parent = ownerNode.getScene().getWindow();
        return parent.getX() + sceneBounds.getMinX() + ownerNode.getScene().getX();
    }

    private double ownerY(Node ownerNode, Bounds sceneBounds) {
        Window parent = ownerNode.getScene().getWindow();
        return parent.getY() + sceneBounds.getMinY() + ownerNode.getScene().getY();
    }

    public void showOnAnchors(Node ownerNode, double anchorX, double anchorY) {
        this.hiding = false;
        Bounds sceneBounds = ownerNode.localToScene(ownerNode.getBoundsInLocal());
        if (this.isShowing()) {
            this.animation.setOnFinished(null);
            this.animation.reverseAndContinue();
            this.setAnchorX(this.getUpdatedAnchorX(anchorX += this.ownerX(ownerNode, sceneBounds)));
            this.setAnchorY(this.getUpdatedAnchorY(anchorY += this.ownerY(ownerNode, sceneBounds)));
        } else {
            super.show(ownerNode, anchorX += this.ownerX(ownerNode, sceneBounds), anchorY += this.ownerY(ownerNode, sceneBounds));
        }
    }

    private double getHPosForNode(Bounds sceneBounds) {
        double hx = -this.margin;
        switch (this.pos.getHpos()) {
            case CENTER: {
                hx = sceneBounds.getWidth() / 2.0;
                break;
            }
            case RIGHT: {
                hx = sceneBounds.getWidth() + this.margin;
            }
        }
        return hx;
    }

    private double getVPosForNode(Bounds sceneBounds) {
        double vy = -this.margin;
        switch (this.pos.getVpos()) {
            case CENTER: {
                vy = sceneBounds.getHeight() / 2.0;
                break;
            }
            case BOTTOM: {
                vy = sceneBounds.getHeight() + this.margin;
            }
        }
        return vy;
    }

    protected Skin<?> createDefaultSkin() {
        return new TooltipSkin(this){
            {
                Node node = this.getNode();
                node.setEffect(null);
            }
        };
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return super.buildEventDispatchChain(tail).prepend((EventDispatcher)this.eventHandlerManager);
    }

    static /* synthetic */ void lambda$hide$8(JFXTooltip this_) {
        super.hide();
    }

    static /* synthetic */ void lambda$init$7(JFXTooltip this_, WindowEvent event) {
        this_.setAnchorX(this_.getUpdatedAnchorX(this_.getAnchorX()));
        this_.setAnchorY(this_.getUpdatedAnchorY(this_.getAnchorY()));
        this_.animation.reverseAndContinue();
    }

    static /* synthetic */ void lambda$init$6(JFXTooltip this_, WindowEvent event) {
        this_.root = this_.getScene().getRoot();
        this_.root.setOpacity(0.0);
        this_.root.setScaleY(0.8);
        this_.root.setScaleX(0.8);
        this_.animation.setOnFinished(null);
    }

    static /* synthetic */ WritableValue lambda$new$5(JFXTooltip this_) {
        return this_.root.opacityProperty();
    }

    static /* synthetic */ Boolean lambda$new$4(JFXTooltip this_) {
        return this_.hiding;
    }

    static /* synthetic */ WritableValue lambda$new$3(JFXTooltip this_) {
        return this_.root.scaleYProperty();
    }

    static /* synthetic */ WritableValue lambda$new$2(JFXTooltip this_) {
        return this_.root.scaleXProperty();
    }

    static /* synthetic */ WritableValue lambda$new$1(JFXTooltip this_) {
        return this_.root.opacityProperty();
    }

    static /* synthetic */ Boolean lambda$new$0(JFXTooltip this_) {
        return !this_.hiding;
    }

    private static class TooltipBehavior {
        private static String TOOLTIP_PROP = "jfoenix-tooltip";
        private Timeline hoverTimer = new Timeline();
        private Timeline visibleTimer = new Timeline();
        private Timeline leftTimer = new Timeline();
        private Node hoveredNode;
        private JFXTooltip nextTooltip;
        private JFXTooltip currentTooltip;
        private EventHandler<MouseEvent> moveHandler = JFXTooltip$TooltipBehavior$$Lambda$1.lambdaFactory$(this);
        private WeakEventHandler<MouseEvent> weakMoveHandler = new WeakEventHandler(this.moveHandler);
        private EventHandler<MouseEvent> exitHandler = JFXTooltip$TooltipBehavior$$Lambda$2.lambdaFactory$(this);
        private WeakEventHandler<MouseEvent> weakExitHandler = new WeakEventHandler(this.exitHandler);
        private EventHandler<MouseEvent> pressedHandler = JFXTooltip$TooltipBehavior$$Lambda$3.lambdaFactory$(this);
        private WeakEventHandler<MouseEvent> weakPressedHandler = new WeakEventHandler(this.pressedHandler);

        private TooltipBehavior(Duration hoverDelay, Duration visibleDuration, Duration leftDelay) {
            this.setHoverDelay(hoverDelay);
            this.hoverTimer.setOnFinished(JFXTooltip$TooltipBehavior$$Lambda$4.lambdaFactory$(this));
            this.setVisibleDuration(visibleDuration);
            this.visibleTimer.setOnFinished(JFXTooltip$TooltipBehavior$$Lambda$5.lambdaFactory$(this));
            this.setLeftDelay(leftDelay);
            this.leftTimer.setOnFinished(JFXTooltip$TooltipBehavior$$Lambda$6.lambdaFactory$(this));
        }

        private void setHoverDelay(Duration duration) {
            this.hoverTimer.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(duration, new KeyValue[0])});
        }

        private void setVisibleDuration(Duration duration) {
            this.visibleTimer.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(duration, new KeyValue[0])});
        }

        private void setLeftDelay(Duration duration) {
            this.leftTimer.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(duration, new KeyValue[0])});
        }

        private void hideCurrentTooltip() {
            this.currentTooltip.hide();
            this.currentTooltip = null;
            this.hoveredNode = null;
        }

        private void showTooltip(JFXTooltip tooltip) {
            tooltip.show(this.hoveredNode, -1.0, -1.0);
        }

        private void install(Node node, JFXTooltip tooltip) {
            if (node == null) {
                return;
            }
            if (tooltip == null) {
                this.uninstall(node);
                return;
            }
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.weakMoveHandler);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.weakExitHandler);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.weakPressedHandler);
            node.addEventHandler(MouseEvent.MOUSE_MOVED, this.weakMoveHandler);
            node.addEventHandler(MouseEvent.MOUSE_EXITED, this.weakExitHandler);
            node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.weakPressedHandler);
            node.getProperties().put((Object)TOOLTIP_PROP, (Object)tooltip);
        }

        private void uninstall(Node node) {
            if (node == null) {
                return;
            }
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.weakMoveHandler);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.weakExitHandler);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.weakPressedHandler);
            Object tooltip = node.getProperties().get((Object)TOOLTIP_PROP);
            if (tooltip != null) {
                node.getProperties().remove((Object)TOOLTIP_PROP);
                if (tooltip.equals((Object)this.currentTooltip) || tooltip.equals((Object)this.nextTooltip)) {
                    this.weakPressedHandler.handle(null);
                }
            }
        }

        private void ensureHoveredNodeIsVisible(Runnable visibleRunnable) {
            boolean treeVisible;
            Window owner = this.getWindow(this.hoveredNode);
            if (owner != null && owner.isShowing() && (treeVisible = this.hoveredNode.impl_isTreeVisible())) {
                visibleRunnable.run();
            }
        }

        private Window getWindow(Node node) {
            Scene scene = node == null ? null : node.getScene();
            return scene == null ? null : scene.getWindow();
        }

        static /* synthetic */ void lambda$new$7(TooltipBehavior this_, MouseEvent event) {
            this_.hoverTimer.stop();
            this_.visibleTimer.stop();
            this_.leftTimer.stop();
            if (this_.currentTooltip != null) {
                this_.currentTooltip.hide();
            }
            this_.hoveredNode = null;
            this_.currentTooltip = null;
            this_.nextTooltip = null;
        }

        static /* synthetic */ void lambda$new$6(TooltipBehavior this_, MouseEvent event) {
            if (this_.hoverTimer.getStatus() == Animation.Status.RUNNING) {
                this_.hoverTimer.stop();
            } else if (this_.visibleTimer.getStatus() == Animation.Status.RUNNING) {
                this_.visibleTimer.stop();
                this_.leftTimer.playFromStart();
            }
            this_.hoveredNode = null;
            this_.nextTooltip = null;
        }

        static /* synthetic */ void lambda$new$5(TooltipBehavior this_, MouseEvent event) {
            if (this_.visibleTimer.getStatus() == Animation.Status.RUNNING) {
                return;
            }
            this_.hoveredNode = (Node)event.getSource();
            Object property = this_.hoveredNode.getProperties().get((Object)TOOLTIP_PROP);
            if (property instanceof JFXTooltip) {
                JFXTooltip tooltip = (JFXTooltip)((Object)property);
                this_.ensureHoveredNodeIsVisible(JFXTooltip$TooltipBehavior$$Lambda$7.lambdaFactory$(this_, tooltip));
            } else {
                this_.uninstall(this_.hoveredNode);
            }
        }

        static /* synthetic */ void lambda$null$4(TooltipBehavior this_, JFXTooltip tooltip) {
            if (this_.leftTimer.getStatus() == Animation.Status.RUNNING) {
                if (this_.currentTooltip != null) {
                    this_.currentTooltip.hide();
                }
                this_.currentTooltip = tooltip;
                this_.showTooltip(tooltip);
                this_.leftTimer.stop();
                this_.visibleTimer.playFromStart();
            } else {
                this_.nextTooltip = tooltip;
                this_.hoverTimer.stop();
                this_.hoverTimer.playFromStart();
            }
        }

        static /* synthetic */ void lambda$new$3(TooltipBehavior this_, ActionEvent event) {
            this_.hideCurrentTooltip();
        }

        static /* synthetic */ void lambda$new$2(TooltipBehavior this_, ActionEvent event) {
            this_.hideCurrentTooltip();
        }

        static /* synthetic */ void lambda$new$1(TooltipBehavior this_, ActionEvent event) {
            this_.ensureHoveredNodeIsVisible(JFXTooltip$TooltipBehavior$$Lambda$8.lambdaFactory$(this_));
            this_.nextTooltip = null;
        }

        static /* synthetic */ void lambda$null$0(TooltipBehavior this_) {
            NodeOrientation nodeOrientation = this_.hoveredNode.getEffectiveNodeOrientation();
            this_.nextTooltip.getScene().setNodeOrientation(nodeOrientation);
            this_.showTooltip(this_.nextTooltip);
            this_.currentTooltip = this_.nextTooltip;
            this_.hoveredNode = null;
            this_.visibleTimer.playFromStart();
        }
    }
}

