/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.animation.alert.JFXAlertAnimation;
import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.controls.JFXAlert$$Lambda$1;
import com.jfoenix.controls.JFXAlert$$Lambda$10;
import com.jfoenix.controls.JFXAlert$$Lambda$11;
import com.jfoenix.controls.JFXAlert$$Lambda$12;
import com.jfoenix.controls.JFXAlert$$Lambda$13;
import com.jfoenix.controls.JFXAlert$$Lambda$2;
import com.jfoenix.controls.JFXAlert$$Lambda$3;
import com.jfoenix.controls.JFXAlert$$Lambda$4;
import com.jfoenix.controls.JFXAlert$$Lambda$5;
import com.jfoenix.controls.JFXAlert$$Lambda$6;
import com.jfoenix.controls.JFXAlert$$Lambda$7;
import com.jfoenix.controls.JFXAlert$$Lambda$8;
import com.jfoenix.controls.JFXAlert$$Lambda$9;
import com.jfoenix.effects.JFXDepthManager;
import com.sun.javafx.event.EventHandlerManager;
import java.util.List;
import javafx.animation.Animation;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.DialogPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class JFXAlert<R>
extends Dialog<R> {
    private final StackPane contentContainer;
    private InvalidationListener widthListener;
    private InvalidationListener heightListener;
    private InvalidationListener xListener;
    private InvalidationListener yListener;
    private boolean animateClosing = true;
    private Animation transition = null;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);
    private BooleanProperty overlayClose = new SimpleBooleanProperty(true);
    private ObjectProperty<JFXAlertAnimation> animation = new SimpleObjectProperty((Object)JFXAlertAnimation.CENTER_ANIMATION);
    private BooleanProperty hideOnEscape = new SimpleBooleanProperty((Object)this, "hideOnEscape", true);

    public JFXAlert() {
        this(null);
    }

    public JFXAlert(Window window) {
        this.contentContainer = new StackPane();
        this.contentContainer.getStyleClass().add((Object)"jfx-alert-content-container");
        Node materialNode = JFXDepthManager.createMaterialNode((Node)this.contentContainer, 2);
        materialNode.setPickOnBounds(false);
        materialNode.addEventHandler(MouseEvent.MOUSE_CLICKED, JFXAlert$$Lambda$1.lambdaFactory$());
        DialogPane dialogPane = new DialogPane(){
            private boolean performingLayout = false;
            {
                this.getButtonTypes().add((Object)ButtonType.CLOSE);
                Node closeButton = this.lookupButton(ButtonType.CLOSE);
                closeButton.managedProperty().bind((ObservableValue)closeButton.visibleProperty());
                closeButton.setVisible(false);
            }

            protected double computePrefHeight(double width) {
                Window owner = JFXAlert.this.getOwner();
                if (owner != null) {
                    return owner.getHeight();
                }
                return super.computePrefHeight(width);
            }

            protected double computePrefWidth(double height) {
                Window owner = JFXAlert.this.getOwner();
                if (owner != null) {
                    return owner.getWidth();
                }
                return super.computePrefWidth(height);
            }

            public void requestLayout() {
                if (this.performingLayout) {
                    return;
                }
                super.requestLayout();
            }

            protected void layoutChildren() {
                this.performingLayout = true;
                List managed = this.getManagedChildren();
                double width = this.getWidth();
                double height = this.getHeight();
                double top = this.getInsets().getTop();
                double right = this.getInsets().getRight();
                double left = this.getInsets().getLeft();
                double bottom = this.getInsets().getBottom();
                double contentWidth = width - left - right;
                double contentHeight = height - top - bottom;
                for (Node child : managed) {
                    this.layoutInArea(child, left, top, contentWidth, contentHeight, 0.0, Insets.EMPTY, HPos.CENTER, VPos.CENTER);
                }
                this.performingLayout = false;
            }

            public String getUserAgentStylesheet() {
                return JFoenixResources.load("css/controls/jfx-alert.css").toExternalForm();
            }

            protected Node createButtonBar() {
                return null;
            }
        };
        dialogPane.getStyleClass().add((Object)"jfx-alert-overlay");
        dialogPane.setContent(materialNode);
        this.setDialogPane(dialogPane);
        dialogPane.getScene().setFill((Paint)Color.TRANSPARENT);
        if (window != null) {
            this.initStyle(StageStyle.TRANSPARENT);
            this.initOwner(window);
            dialogPane.addEventHandler(MouseEvent.MOUSE_CLICKED, JFXAlert$$Lambda$2.lambdaFactory$(this));
            this.widthListener = JFXAlert$$Lambda$3.lambdaFactory$(this);
            this.heightListener = JFXAlert$$Lambda$4.lambdaFactory$(this);
            this.xListener = JFXAlert$$Lambda$5.lambdaFactory$(this);
            this.yListener = JFXAlert$$Lambda$6.lambdaFactory$(this);
        }
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_SHOWING, JFXAlert$$Lambda$7.lambdaFactory$(this, dialogPane));
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_SHOWN, JFXAlert$$Lambda$8.lambdaFactory$(this, dialogPane));
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_CLOSE_REQUEST, JFXAlert$$Lambda$9.lambdaFactory$(this));
        this.eventHandlerManager.addEventHandler(DialogEvent.DIALOG_HIDDEN, JFXAlert$$Lambda$10.lambdaFactory$(this));
        this.getDialogPane().getScene().getWindow().addEventFilter(KeyEvent.KEY_PRESSED, JFXAlert$$Lambda$11.lambdaFactory$(this));
    }

    private JFXAlertAnimation getCurrentAnimation() {
        JFXAlertAnimation usedAnimation = this.getAnimation();
        usedAnimation = usedAnimation == null ? JFXAlertAnimation.NO_ANIMATION : usedAnimation;
        return usedAnimation;
    }

    private void removeLayoutListeners() {
        Window stage = this.getOwner();
        if (stage != null) {
            stage.getScene().widthProperty().removeListener(this.widthListener);
            stage.getScene().heightProperty().removeListener(this.heightListener);
            stage.xProperty().removeListener(this.xListener);
            stage.yProperty().removeListener(this.yListener);
        }
    }

    private void addLayoutListeners() {
        Window stage = this.getOwner();
        if (stage != null) {
            if (this.widthListener == null) {
                throw new RuntimeException("Owner can only be set using the constructor");
            }
            stage.getScene().widthProperty().addListener(this.widthListener);
            stage.getScene().heightProperty().addListener(this.heightListener);
            stage.xProperty().addListener(this.xListener);
            stage.yProperty().addListener(this.yListener);
        }
    }

    private void updateLayout() {
        this.updateX();
        this.updateY();
        this.updateWidth();
        this.updateHeight();
    }

    private void updateHeight() {
        Window stage = this.getOwner();
        this.setHeight(stage.getScene().getHeight());
    }

    private void updateWidth() {
        Window stage = this.getOwner();
        this.setWidth(stage.getScene().getWidth());
    }

    private void updateY() {
        Window stage = this.getOwner();
        this.setY(stage.getY() + stage.getScene().getY());
    }

    private void updateX() {
        Window stage = this.getOwner();
        this.setX(stage.getX() + stage.getScene().getX());
    }

    public void hideWithAnimation() {
        if (this.transition == null || this.transition.getStatus().equals((Object)Animation.Status.STOPPED)) {
            JFXAlertAnimation currentAnimation = this.getCurrentAnimation();
            Animation animation = currentAnimation.createHidingAnimation(this.getDialogPane().getContent(), (Node)this.getDialogPane());
            if (animation != null) {
                this.transition = animation;
                animation.setOnFinished(JFXAlert$$Lambda$12.lambdaFactory$(this));
                animation.play();
            } else {
                this.animateClosing = false;
                this.transition = null;
                Platform.runLater((Runnable)JFXAlert$$Lambda$13.lambdaFactory$(this));
            }
        }
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return super.buildEventDispatchChain(tail).prepend((EventDispatcher)this.eventHandlerManager);
    }

    public void setContent(Node ... content) {
        this.contentContainer.getChildren().setAll((Object[])content);
    }

    public boolean isOverlayClose() {
        return this.overlayClose.get();
    }

    public BooleanProperty overlayCloseProperty() {
        return this.overlayClose;
    }

    public void setOverlayClose(boolean overlayClose) {
        this.overlayClose.set(overlayClose);
    }

    public JFXAlertAnimation getAnimation() {
        return (JFXAlertAnimation)this.animation.get();
    }

    public ObjectProperty<JFXAlertAnimation> animationProperty() {
        return this.animation;
    }

    public void setAnimation(JFXAlertAnimation animation) {
        this.animation.set((Object)animation);
    }

    public void setSize(double prefWidth, double prefHeight) {
        this.contentContainer.setPrefSize(prefWidth, prefHeight);
    }

    public final void setHideOnEscape(boolean value) {
        this.hideOnEscape.set(value);
    }

    public final boolean isHideOnEscape() {
        return this.hideOnEscape.get();
    }

    public final BooleanProperty hideOnEscapeProperty() {
        return this.hideOnEscape;
    }

    static /* synthetic */ void lambda$hideWithAnimation$10(JFXAlert this_, ActionEvent finish) {
        this_.animateClosing = false;
        this_.hide();
        this_.transition = null;
    }

    static /* synthetic */ void lambda$new$9(JFXAlert this_, KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.ESCAPE && !this_.isHideOnEscape()) {
            keyEvent.consume();
        }
    }

    static /* synthetic */ void lambda$new$8(JFXAlert this_, DialogEvent event) {
        this_.removeLayoutListeners();
    }

    static /* synthetic */ void lambda$new$7(JFXAlert this_, DialogEvent event) {
        if (this_.animateClosing) {
            event.consume();
            this_.hideWithAnimation();
        }
    }

    static /* synthetic */ void lambda$new$6(JFXAlert this_, DialogPane dialogPane, DialogEvent event) {
        if (this_.getOwner() != null) {
            this_.updateLayout();
        }
        this_.animateClosing = true;
        JFXAlertAnimation currentAnimation = this_.getCurrentAnimation();
        Animation animation = currentAnimation.createShowingAnimation(dialogPane.getContent(), (Node)dialogPane);
        if (animation != null) {
            animation.play();
        }
    }

    static /* synthetic */ void lambda$new$5(JFXAlert this_, DialogPane dialogPane, DialogEvent event) {
        this_.addLayoutListeners();
        JFXAlertAnimation currentAnimation = this_.getCurrentAnimation();
        currentAnimation.initAnimation((Node)this_.contentContainer.getParent(), (Node)dialogPane);
    }

    static /* synthetic */ void lambda$new$4(JFXAlert this_, Observable observable) {
        this_.updateY();
    }

    static /* synthetic */ void lambda$new$3(JFXAlert this_, Observable observable) {
        this_.updateX();
    }

    static /* synthetic */ void lambda$new$2(JFXAlert this_, Observable observable) {
        this_.updateHeight();
    }

    static /* synthetic */ void lambda$new$1(JFXAlert this_, Observable observable) {
        this_.updateWidth();
    }

    static /* synthetic */ void lambda$new$0(JFXAlert this_, MouseEvent event) {
        if (this_.isOverlayClose()) {
            this_.hide();
        }
    }
}

