/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentListArgument;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.BooleanValueArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.DurationArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ArgumentParser
implements Serializable {
    public static final String PROPERTY_DEFAULT_PROPERTIES_FILE_PATH = ArgumentParser.class.getName() + ".propertiesFilePath";
    public static final String ENV_DEFAULT_PROPERTIES_FILE_PATH = "UNBOUNDID_TOOL_PROPERTIES_FILE_PATH";
    private static final String ARG_NAME_PROPERTIES_FILE_PATH = "propertiesFilePath";
    private static final String ARG_NAME_GENERATE_PROPERTIES_FILE = "generatePropertiesFile";
    private static final String ARG_NAME_NO_PROPERTIES_FILE = "noPropertiesFile";
    private static final long serialVersionUID = 3053102992180360269L;
    private final int maxTrailingArgs;
    private final int minTrailingArgs;
    private final LinkedHashMap<Character, Argument> namedArgsByShortID;
    private final LinkedHashMap<String, Argument> namedArgsByLongID;
    private final List<Argument> namedArgs;
    private final List<ObjectPair<Argument, Set<Argument>>> dependentArgumentSets;
    private final List<Set<Argument>> exclusiveArgumentSets;
    private final List<Set<Argument>> requiredArgumentSets;
    private final List<String> trailingArgs;
    private final String commandDescription;
    private final String commandName;
    private final String trailingArgsPlaceholder;

    public ArgumentParser(String commandName, String commandDescription) throws ArgumentException {
        this(commandName, commandDescription, 0, null);
    }

    public ArgumentParser(String commandName, String commandDescription, int maxTrailingArgs, String trailingArgsPlaceholder) throws ArgumentException {
        this(commandName, commandDescription, 0, maxTrailingArgs, trailingArgsPlaceholder);
    }

    public ArgumentParser(String commandName, String commandDescription, int minTrailingArgs, int maxTrailingArgs, String trailingArgsPlaceholder) throws ArgumentException {
        if (commandName == null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_COMMAND_NAME_NULL.get());
        }
        if (commandDescription == null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_COMMAND_DESCRIPTION_NULL.get());
        }
        if (maxTrailingArgs != 0 && trailingArgsPlaceholder == null) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_TRAILING_ARGS_PLACEHOLDER_NULL.get());
        }
        this.commandName = commandName;
        this.commandDescription = commandDescription;
        this.trailingArgsPlaceholder = trailingArgsPlaceholder;
        this.minTrailingArgs = minTrailingArgs >= 0 ? minTrailingArgs : 0;
        this.maxTrailingArgs = maxTrailingArgs >= 0 ? maxTrailingArgs : Integer.MAX_VALUE;
        if (this.minTrailingArgs > this.maxTrailingArgs) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_TRAILING_ARGS_COUNT_MISMATCH.get(this.minTrailingArgs, this.maxTrailingArgs));
        }
        this.namedArgsByShortID = new LinkedHashMap();
        this.namedArgsByLongID = new LinkedHashMap();
        this.namedArgs = new ArrayList<Argument>();
        this.trailingArgs = new ArrayList<String>();
        this.dependentArgumentSets = new ArrayList<ObjectPair<Argument, Set<Argument>>>();
        this.exclusiveArgumentSets = new ArrayList<Set<Argument>>();
        this.requiredArgumentSets = new ArrayList<Set<Argument>>();
    }

    private ArgumentParser(ArgumentParser source) {
        LinkedHashSet newSet;
        this.commandName = source.commandName;
        this.commandDescription = source.commandDescription;
        this.minTrailingArgs = source.minTrailingArgs;
        this.maxTrailingArgs = source.maxTrailingArgs;
        this.trailingArgsPlaceholder = source.trailingArgsPlaceholder;
        this.trailingArgs = new ArrayList<String>();
        this.namedArgs = new ArrayList<Argument>(source.namedArgs.size());
        this.namedArgsByLongID = new LinkedHashMap(source.namedArgsByLongID.size());
        this.namedArgsByShortID = new LinkedHashMap(source.namedArgsByShortID.size());
        LinkedHashMap<String, Argument> argsByID = new LinkedHashMap<String, Argument>(source.namedArgs.size());
        for (Argument argument : source.namedArgs) {
            Argument a = argument.getCleanCopy();
            try {
                a.setRegistered();
            }
            catch (ArgumentException ae) {
                Debug.debugException(ae);
            }
            this.namedArgs.add(a);
            argsByID.put(a.getIdentifierString(), a);
            for (Character c : a.getShortIdentifiers()) {
                this.namedArgsByShortID.put(c, a);
            }
            for (String s : a.getLongIdentifiers()) {
                this.namedArgsByLongID.put(StaticUtils.toLowerCase(s), a);
            }
        }
        this.dependentArgumentSets = new ArrayList<ObjectPair<Argument, Set<Argument>>>(source.dependentArgumentSets.size());
        for (ObjectPair objectPair : source.dependentArgumentSets) {
            Set sourceSet = (Set)objectPair.getSecond();
            LinkedHashSet newSet2 = new LinkedHashSet(sourceSet.size());
            for (Argument a : sourceSet) {
                newSet2.add(argsByID.get(a.getIdentifierString()));
            }
            Argument sourceFirst = (Argument)objectPair.getFirst();
            Argument newFirst = (Argument)argsByID.get(sourceFirst.getIdentifierString());
            this.dependentArgumentSets.add(new ObjectPair(newFirst, newSet2));
        }
        this.exclusiveArgumentSets = new ArrayList<Set<Argument>>(source.exclusiveArgumentSets.size());
        for (Set set : source.exclusiveArgumentSets) {
            newSet = new LinkedHashSet(set.size());
            for (Argument a : set) {
                newSet.add(argsByID.get(a.getIdentifierString()));
            }
            this.exclusiveArgumentSets.add(newSet);
        }
        this.requiredArgumentSets = new ArrayList<Set<Argument>>(source.requiredArgumentSets.size());
        for (Set set : source.requiredArgumentSets) {
            newSet = new LinkedHashSet(set.size());
            for (Argument a : set) {
                newSet.add(argsByID.get(a.getIdentifierString()));
            }
            this.requiredArgumentSets.add(newSet);
        }
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandDescription() {
        return this.commandDescription;
    }

    public boolean allowsTrailingArguments() {
        return this.maxTrailingArgs != 0;
    }

    public boolean requiresTrailingArguments() {
        return this.minTrailingArgs != 0;
    }

    public String getTrailingArgumentsPlaceholder() {
        return this.trailingArgsPlaceholder;
    }

    public int getMinTrailingArguments() {
        return this.minTrailingArgs;
    }

    public int getMaxTrailingArguments() {
        return this.maxTrailingArgs;
    }

    public void enablePropertiesFileSupport() throws ArgumentException {
        FileArgument propertiesFilePath = new FileArgument(null, ARG_NAME_PROPERTIES_FILE_PATH, false, 1, null, ArgsMessages.INFO_ARG_DESCRIPTION_PROP_FILE_PATH.get(), true, true, true, false);
        propertiesFilePath.setUsageArgument(true);
        propertiesFilePath.addLongIdentifier("properties-file-path");
        this.addArgument(propertiesFilePath);
        FileArgument generatePropertiesFile = new FileArgument(null, ARG_NAME_GENERATE_PROPERTIES_FILE, false, 1, null, ArgsMessages.INFO_ARG_DESCRIPTION_GEN_PROP_FILE.get(), false, true, true, false);
        generatePropertiesFile.setUsageArgument(true);
        generatePropertiesFile.addLongIdentifier("generate-properties-file");
        this.addArgument(generatePropertiesFile);
        BooleanArgument noPropertiesFile = new BooleanArgument(null, ARG_NAME_NO_PROPERTIES_FILE, ArgsMessages.INFO_ARG_DESCRIPTION_NO_PROP_FILE.get());
        noPropertiesFile.setUsageArgument(true);
        noPropertiesFile.addLongIdentifier("no-properties-file");
        this.addArgument(noPropertiesFile);
        this.addExclusiveArgumentSet(propertiesFilePath, noPropertiesFile, new Argument[0]);
    }

    public File getGeneratedPropertiesFile() {
        Argument a = this.getNamedArgument(ARG_NAME_GENERATE_PROPERTIES_FILE);
        if (a == null || !a.isPresent() || !(a instanceof FileArgument)) {
            return null;
        }
        return ((FileArgument)a).getValue();
    }

    public Argument getNamedArgument(Character shortIdentifier) {
        Validator.ensureNotNull(shortIdentifier);
        return this.namedArgsByShortID.get(shortIdentifier);
    }

    public Argument getNamedArgument(String identifier) {
        Validator.ensureNotNull(identifier);
        if (identifier.startsWith("--") && identifier.length() > 2) {
            return this.namedArgsByLongID.get(StaticUtils.toLowerCase(identifier.substring(2)));
        }
        if (identifier.startsWith("-") && identifier.length() == 2) {
            return this.namedArgsByShortID.get(Character.valueOf(identifier.charAt(1)));
        }
        return this.namedArgsByLongID.get(StaticUtils.toLowerCase(identifier));
    }

    public ArgumentListArgument getArgumentListArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (ArgumentListArgument)a;
    }

    public BooleanArgument getBooleanArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (BooleanArgument)a;
    }

    public BooleanValueArgument getBooleanValueArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (BooleanValueArgument)a;
    }

    public ControlArgument getControlArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (ControlArgument)a;
    }

    public DNArgument getDNArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (DNArgument)a;
    }

    public DurationArgument getDurationArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (DurationArgument)a;
    }

    public FileArgument getFileArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (FileArgument)a;
    }

    public FilterArgument getFilterArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (FilterArgument)a;
    }

    public IntegerArgument getIntegerArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (IntegerArgument)a;
    }

    public ScopeArgument getScopeArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (ScopeArgument)a;
    }

    public StringArgument getStringArgument(String identifier) {
        Argument a = this.getNamedArgument(identifier);
        if (a == null) {
            return null;
        }
        return (StringArgument)a;
    }

    public List<Argument> getNamedArguments() {
        return Collections.unmodifiableList(this.namedArgs);
    }

    public void addArgument(Argument argument) throws ArgumentException {
        argument.setRegistered();
        for (Character c : argument.getShortIdentifiers()) {
            if (!this.namedArgsByShortID.containsKey(c)) continue;
            throw new ArgumentException(ArgsMessages.ERR_PARSER_SHORT_ID_CONFLICT.get(c));
        }
        for (String s : argument.getLongIdentifiers()) {
            if (!this.namedArgsByLongID.containsKey(StaticUtils.toLowerCase(s))) continue;
            throw new ArgumentException(ArgsMessages.ERR_PARSER_LONG_ID_CONFLICT.get(s));
        }
        for (Character c : argument.getShortIdentifiers()) {
            this.namedArgsByShortID.put(c, argument);
        }
        for (String s : argument.getLongIdentifiers()) {
            this.namedArgsByLongID.put(StaticUtils.toLowerCase(s), argument);
        }
        this.namedArgs.add(argument);
    }

    public List<ObjectPair<Argument, Set<Argument>>> getDependentArgumentSets() {
        return Collections.unmodifiableList(this.dependentArgumentSets);
    }

    public void addDependentArgumentSet(Argument targetArgument, Collection<Argument> dependentArguments) {
        Validator.ensureNotNull(targetArgument, dependentArguments);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(dependentArguments);
        this.dependentArgumentSets.add(new ObjectPair<Argument, LinkedHashSet<Argument>>(targetArgument, argSet));
    }

    public void addDependentArgumentSet(Argument targetArgument, Argument dependentArg1, Argument ... remaining) {
        Validator.ensureNotNull(targetArgument, dependentArg1);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>();
        argSet.add(dependentArg1);
        argSet.addAll(Arrays.asList(remaining));
        this.dependentArgumentSets.add(new ObjectPair(targetArgument, argSet));
    }

    public List<Set<Argument>> getExclusiveArgumentSets() {
        return Collections.unmodifiableList(this.exclusiveArgumentSets);
    }

    public void addExclusiveArgumentSet(Collection<Argument> exclusiveArguments) {
        Validator.ensureNotNull(exclusiveArguments);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(exclusiveArguments);
        this.exclusiveArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public void addExclusiveArgumentSet(Argument arg1, Argument arg2, Argument ... remaining) {
        Validator.ensureNotNull(arg1, arg2);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>();
        argSet.add(arg1);
        argSet.add(arg2);
        argSet.addAll(Arrays.asList(remaining));
        this.exclusiveArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public List<Set<Argument>> getRequiredArgumentSets() {
        return Collections.unmodifiableList(this.requiredArgumentSets);
    }

    public void addRequiredArgumentSet(Collection<Argument> requiredArguments) {
        Validator.ensureNotNull(requiredArguments);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>(requiredArguments);
        this.requiredArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public void addRequiredArgumentSet(Argument arg1, Argument arg2, Argument ... remaining) {
        Validator.ensureNotNull(arg1, arg2);
        LinkedHashSet<Argument> argSet = new LinkedHashSet<Argument>();
        argSet.add(arg1);
        argSet.add(arg2);
        argSet.addAll(Arrays.asList(remaining));
        this.requiredArgumentSets.add(Collections.unmodifiableSet(argSet));
    }

    public List<String> getTrailingArguments() {
        return Collections.unmodifiableList(this.trailingArgs);
    }

    void resetTrailingArguments() {
        this.trailingArgs.clear();
    }

    void addTrailingArgument(String value) throws ArgumentException {
        if (this.maxTrailingArgs > 0 && this.trailingArgs.size() >= this.maxTrailingArgs) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_TOO_MANY_TRAILING_ARGS.get(value, this.commandName, this.maxTrailingArgs));
        }
        this.trailingArgs.add(value);
    }

    public ArgumentParser getCleanCopy() {
        return new ArgumentParser(this);
    }

    public void parse(String[] args) throws ArgumentException {
        boolean inTrailingArgs = false;
        boolean skipFinalValidation = false;
        for (int i = 0; i < args.length; ++i) {
            String string = args[i];
            if (inTrailingArgs) {
                if (this.maxTrailingArgs == 0) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_TRAILING_ARGS_NOT_ALLOWED.get(string, this.commandName));
                }
                if (this.trailingArgs.size() >= this.maxTrailingArgs) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_TOO_MANY_TRAILING_ARGS.get(string, this.commandName, this.maxTrailingArgs));
                }
                this.trailingArgs.add(string);
                continue;
            }
            if (string.equals("--")) {
                inTrailingArgs = true;
                continue;
            }
            if (string.startsWith("--")) {
                int equalPos = string.indexOf(61);
                String argName = equalPos > 0 ? string.substring(2, equalPos) : string.substring(2);
                Argument a = this.namedArgsByLongID.get(StaticUtils.toLowerCase(argName));
                if (a == null) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_LONG_ID.get(argName));
                }
                if (a.isUsageArgument()) {
                    skipFinalValidation |= ArgumentParser.skipFinalValidationBecauseOfArgument(a);
                }
                a.incrementOccurrences();
                if (a.takesValue()) {
                    if (equalPos > 0) {
                        a.addValue(string.substring(equalPos + 1));
                        continue;
                    }
                    if (++i >= args.length) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_LONG_ARG_MISSING_VALUE.get(argName));
                    }
                    a.addValue(args[i]);
                    continue;
                }
                if (equalPos <= 0) continue;
                throw new ArgumentException(ArgsMessages.ERR_PARSER_LONG_ARG_DOESNT_TAKE_VALUE.get(argName));
            }
            if (string.startsWith("-")) {
                if (string.length() == 1) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_UNEXPECTED_DASH.get());
                }
                if (string.length() == 2) {
                    char c = string.charAt(1);
                    Argument a = this.namedArgsByShortID.get(Character.valueOf(c));
                    if (a == null) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_SHORT_ID.get(Character.valueOf(c)));
                    }
                    if (a.isUsageArgument()) {
                        skipFinalValidation |= ArgumentParser.skipFinalValidationBecauseOfArgument(a);
                    }
                    a.incrementOccurrences();
                    if (!a.takesValue()) continue;
                    if (++i >= args.length) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_SHORT_ARG_MISSING_VALUE.get(Character.valueOf(c)));
                    }
                    a.addValue(args[i]);
                    continue;
                }
                char c = string.charAt(1);
                Argument a = this.namedArgsByShortID.get(Character.valueOf(c));
                if (a == null) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_SHORT_ID.get(Character.valueOf(c)));
                }
                if (a.isUsageArgument()) {
                    skipFinalValidation |= ArgumentParser.skipFinalValidationBecauseOfArgument(a);
                }
                a.incrementOccurrences();
                if (a.takesValue()) {
                    a.addValue(string.substring(2));
                    continue;
                }
                for (int j = 2; j < string.length(); ++j) {
                    c = string.charAt(j);
                    a = this.namedArgsByShortID.get(Character.valueOf(c));
                    if (a == null) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUBSEQUENT_SHORT_ARG.get(Character.valueOf(c), string));
                    }
                    if (a.isUsageArgument()) {
                        skipFinalValidation |= ArgumentParser.skipFinalValidationBecauseOfArgument(a);
                    }
                    a.incrementOccurrences();
                    if (!a.takesValue()) continue;
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_SUBSEQUENT_SHORT_ARG_TAKES_VALUE.get(Character.valueOf(c), string));
                }
                continue;
            }
            inTrailingArgs = true;
            if (this.maxTrailingArgs == 0) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_TRAILING_ARGS_NOT_ALLOWED.get(string, this.commandName));
            }
            this.trailingArgs.add(string);
        }
        if (!this.handlePropertiesFile()) {
            return;
        }
        if (skipFinalValidation) {
            return;
        }
        for (Argument argument : this.namedArgs) {
            if (!argument.isRequired() || argument.isPresent()) continue;
            throw new ArgumentException(ArgsMessages.ERR_PARSER_MISSING_REQUIRED_ARG.get(argument.getIdentifierString()));
        }
        if (this.trailingArgs.size() < this.minTrailingArgs) {
            throw new ArgumentException(ArgsMessages.ERR_PARSER_NOT_ENOUGH_TRAILING_ARGS.get(this.commandName, this.minTrailingArgs, this.trailingArgsPlaceholder));
        }
        for (ObjectPair objectPair : this.dependentArgumentSets) {
            Argument targetArg = (Argument)objectPair.getFirst();
            if (!targetArg.isPresent()) continue;
            Set argSet = (Set)objectPair.getSecond();
            boolean found = false;
            for (Argument a : argSet) {
                if (!a.isPresent()) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (argSet.size() == 1) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_DEPENDENT_CONFLICT_SINGLE.get(targetArg.getIdentifierString(), ((Argument)argSet.iterator().next()).getIdentifierString()));
            }
            boolean first = true;
            StringBuilder buffer = new StringBuilder();
            for (Argument a : argSet) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(a.getIdentifierString());
            }
            throw new ArgumentException(ArgsMessages.ERR_PARSER_DEPENDENT_CONFLICT_MULTIPLE.get(targetArg.getIdentifierString(), buffer.toString()));
        }
        for (Set set : this.exclusiveArgumentSets) {
            Argument setArg = null;
            for (Argument a : set) {
                if (!a.isPresent()) continue;
                if (setArg == null) {
                    setArg = a;
                    continue;
                }
                throw new ArgumentException(ArgsMessages.ERR_PARSER_EXCLUSIVE_CONFLICT.get(setArg.getIdentifierString(), a.getIdentifierString()));
            }
        }
        for (Set set : this.requiredArgumentSets) {
            boolean found = false;
            for (Argument a : set) {
                if (!a.isPresent()) continue;
                found = true;
                break;
            }
            if (found) continue;
            boolean first = true;
            StringBuilder buffer = new StringBuilder();
            for (Argument a : set) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(a.getIdentifierString());
            }
            throw new ArgumentException(ArgsMessages.ERR_PARSER_REQUIRED_CONFLICT.get(buffer.toString()));
        }
    }

    private static boolean skipFinalValidationBecauseOfArgument(Argument a) {
        if (ARG_NAME_PROPERTIES_FILE_PATH.equals(a.getLongIdentifier()) || ARG_NAME_NO_PROPERTIES_FILE.equals(a.getLongIdentifier())) {
            return false;
        }
        return a.isUsageArgument();
    }

    private boolean handlePropertiesFile() throws ArgumentException {
        File propertiesFile;
        BooleanArgument noPropertiesFile;
        FileArgument generatePropertiesFile;
        FileArgument propertiesFilePath;
        try {
            propertiesFilePath = this.getFileArgument(ARG_NAME_PROPERTIES_FILE_PATH);
            generatePropertiesFile = this.getFileArgument(ARG_NAME_GENERATE_PROPERTIES_FILE);
            noPropertiesFile = this.getBooleanArgument(ARG_NAME_NO_PROPERTIES_FILE);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return true;
        }
        if (propertiesFilePath == null || generatePropertiesFile == null || noPropertiesFile == null) {
            return true;
        }
        if (noPropertiesFile.isPresent()) {
            if (propertiesFilePath.isPresent()) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_EXCLUSIVE_CONFLICT.get(noPropertiesFile.getIdentifierString(), propertiesFilePath.getIdentifierString()));
            }
            if (generatePropertiesFile.isPresent()) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_EXCLUSIVE_CONFLICT.get(noPropertiesFile.getIdentifierString(), generatePropertiesFile.getIdentifierString()));
            }
            return true;
        }
        if (generatePropertiesFile.isPresent()) {
            if (propertiesFilePath.isPresent()) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_EXCLUSIVE_CONFLICT.get(generatePropertiesFile.getIdentifierString(), propertiesFilePath.getIdentifierString()));
            }
            this.generatePropertiesFile(generatePropertiesFile.getValue().getAbsolutePath());
            return false;
        }
        if (propertiesFilePath.isPresent()) {
            File propertiesFile2 = propertiesFilePath.getValue();
            if (!propertiesFile2.exists() || !propertiesFile2.isFile()) {
                throw new ArgumentException(ArgsMessages.ERR_PARSER_NO_SUCH_PROPERTIES_FILE.get(propertiesFilePath.getIdentifierString(), propertiesFile2.getAbsolutePath()));
            }
            this.handlePropertiesFile(propertiesFilePath.getValue());
            return true;
        }
        String path = System.getProperty(PROPERTY_DEFAULT_PROPERTIES_FILE_PATH);
        if (path == null) {
            path = System.getenv(ENV_DEFAULT_PROPERTIES_FILE_PATH);
        }
        if (path != null && (propertiesFile = new File(path)).exists() && propertiesFile.isFile()) {
            this.handlePropertiesFile(propertiesFile);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePropertiesFile(String path) throws ArgumentException {
        PrintWriter w;
        try {
            w = new PrintWriter(path);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ArgumentException(ArgsMessages.ERR_PARSER_GEN_PROPS_CANNOT_OPEN_FILE.get(path, StaticUtils.getExceptionMessage(e)), e);
        }
        try {
            ArgumentParser.wrapComment(w, ArgsMessages.INFO_PARSER_GEN_PROPS_HEADER_1.get(this.commandName));
            w.println('#');
            ArgumentParser.wrapComment(w, ArgsMessages.INFO_PARSER_GEN_PROPS_HEADER_2.get(this.commandName, ARG_NAME_PROPERTIES_FILE_PATH, PROPERTY_DEFAULT_PROPERTIES_FILE_PATH, ENV_DEFAULT_PROPERTIES_FILE_PATH, ARG_NAME_NO_PROPERTIES_FILE));
            w.println('#');
            for (Argument a : this.getNamedArguments()) {
                String argName;
                if (a.isUsageArgument() || a.isHidden() || (argName = a.getLongIdentifier()) == null) continue;
                ArgumentParser.wrapComment(w, ArgsMessages.INFO_PARSER_GEN_PROPS_HEADER_3.get(this.commandName, argName));
                w.println('#');
                break;
            }
            ArgumentParser.wrapComment(w, ArgsMessages.INFO_PARSER_GEN_PROPS_HEADER_4.get());
            w.println('#');
            ArgumentParser.wrapComment(w, ArgsMessages.INFO_PARSER_GEN_PROPS_HEADER_5.get(this.commandName));
            for (Argument a : this.getNamedArguments()) {
                if (a.isUsageArgument() || a.isHidden()) continue;
                w.println();
                w.println();
                ArgumentParser.wrapComment(w, a.getDescription());
                w.println('#');
                String constraints = a.getValueConstraints();
                if (constraints != null && constraints.length() > 0 && !(a instanceof BooleanArgument)) {
                    ArgumentParser.wrapComment(w, constraints);
                    w.println('#');
                }
                String identifier = a.getLongIdentifier() != null ? a.getLongIdentifier() : a.getIdentifierString();
                String placeholder = a.getValuePlaceholder();
                if (placeholder == null) {
                    placeholder = a instanceof BooleanArgument ? "{true|false}" : "";
                }
                String propertyName = this.commandName + '.' + identifier;
                w.println("# " + propertyName + '=' + placeholder);
                if (!a.isPresent()) continue;
                for (String s : a.getValueStringRepresentations(false)) {
                    w.println(propertyName + '=' + s);
                }
            }
            Object var12_12 = null;
            w.close();
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            w.close();
            throw throwable;
        }
    }

    private static void wrapComment(PrintWriter w, String s) {
        for (String line : StaticUtils.wrapLine(s, 77)) {
            w.println("# " + line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void handlePropertiesFile(File propertiesFile) throws ArgumentException {
        block26: {
            BufferedReader reader;
            try {
                reader = new BufferedReader(new FileReader(propertiesFile));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new ArgumentException(ArgsMessages.ERR_PARSER_CANNOT_OPEN_PROP_FILE.get(propertiesFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
            boolean lineIsContinued = false;
            int lineNumber = 0;
            ArrayList<ObjectPair<Integer, StringBuilder>> propertyLines = new ArrayList<ObjectPair<Integer, StringBuilder>>(10);
            while (true) {
                boolean hasLeadingWhitespace;
                String line;
                try {
                    line = reader.readLine();
                    ++lineNumber;
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_ERROR_READING_PROP_FILE.get(propertiesFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                }
                if (line == null) {
                    if (!lineIsContinued) break;
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_PROP_FILE_MISSING_CONTINUATION.get(lineNumber - 1, propertiesFile.getAbsolutePath()));
                }
                int initialLength = line.length();
                boolean bl = hasLeadingWhitespace = (line = StaticUtils.trimLeading(line)).length() < initialLength;
                if (hasLeadingWhitespace && !lineIsContinued) {
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_PROP_FILE_UNEXPECTED_LEADING_SPACE.get(propertiesFile.getAbsolutePath(), lineNumber));
                }
                if (line.length() == 0 || line.startsWith("#")) {
                    if (!lineIsContinued) continue;
                    throw new ArgumentException(ArgsMessages.ERR_PARSER_PROP_FILE_MISSING_CONTINUATION.get(lineNumber - 1, propertiesFile.getAbsolutePath()));
                }
                boolean hasTrailingBackslash = line.endsWith("\\");
                if (line.endsWith("\\")) {
                    line = line.substring(0, line.length() - 1);
                }
                if (lineIsContinued) {
                    ((StringBuilder)((ObjectPair)propertyLines.get(propertyLines.size() - 1)).getSecond()).append(line);
                } else {
                    propertyLines.add(new ObjectPair<Integer, StringBuilder>(lineNumber, new StringBuilder(line)));
                }
                lineIsContinued = hasTrailingBackslash;
            }
            if (!propertyLines.isEmpty()) break block25;
            Object var18_17 = null;
            try {
                reader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            {
                block25: {
                    return;
                }
                HashMap<String, ArrayList<String>> propertyMap = new HashMap<String, ArrayList<String>>(propertyLines.size());
                for (ObjectPair p : propertyLines) {
                    String line = ((StringBuilder)p.getSecond()).toString();
                    int equalPos = line.indexOf(61);
                    if (equalPos <= 0) {
                        throw new ArgumentException(ArgsMessages.ERR_PARSER_MALFORMED_PROP_LINE.get(propertiesFile.getAbsolutePath(), p.getFirst(), line));
                    }
                    String propertyName = line.substring(0, equalPos).trim();
                    String propertyValue = line.substring(equalPos + 1).trim();
                    if (propertyValue.length() == 0) continue;
                    boolean prefixedWithToolName = false;
                    Argument a = this.getNamedArgument(propertyName);
                    if (a == null && propertyName.startsWith(this.commandName + '.')) {
                        String basePropertyName = propertyName.substring(this.commandName.length() + 1);
                        a = this.getNamedArgument(basePropertyName);
                        prefixedWithToolName = true;
                    }
                    if (a == null) continue;
                    String canonicalPropertyName = prefixedWithToolName ? this.commandName + '.' + a.getIdentifierString() : a.getIdentifierString();
                    ArrayList<String> valueList = (ArrayList<String>)propertyMap.get(canonicalPropertyName);
                    if (valueList == null) {
                        valueList = new ArrayList<String>(5);
                        propertyMap.put(canonicalPropertyName, valueList);
                    }
                    valueList.add(propertyValue);
                }
                for (Argument a : this.namedArgs) {
                    if (a.getNumOccurrences() > 0) continue;
                    List values = (List)propertyMap.get(this.commandName + '.' + a.getIdentifierString());
                    if (values == null) {
                        values = (List)propertyMap.get(a.getIdentifierString());
                    }
                    if (values == null) continue;
                    for (String value : values) {
                        if (a instanceof BooleanArgument) {
                            BooleanValueArgument bva = new BooleanValueArgument(a.getShortIdentifier(), a.getLongIdentifier(), false, null, a.getDescription());
                            bva.addValue(value);
                            if (!bva.getValue().booleanValue()) continue;
                            a.incrementOccurrences();
                            continue;
                        }
                        a.addValue(value);
                        a.incrementOccurrences();
                    }
                }
            }
            Object var18_18 = null;
            try {
                reader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            break block26;
            catch (Throwable throwable) {
                Object var18_19 = null;
                try {
                    reader.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                throw throwable;
            }
        }
    }

    public List<String> getUsage(int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>(100);
        lines.addAll(StaticUtils.wrapLine(this.commandDescription, maxWidth));
        lines.add("");
        if (this.namedArgs.isEmpty()) {
            if (this.maxTrailingArgs == 0) {
                lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_NOOPTIONS_NOTRAILING.get(this.commandName), maxWidth));
            } else {
                lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_NOOPTIONS_TRAILING.get(this.commandName, this.trailingArgsPlaceholder), maxWidth));
            }
        } else {
            if (this.maxTrailingArgs == 0) {
                lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_OPTIONS_NOTRAILING.get(this.commandName), maxWidth));
            } else {
                lines.addAll(StaticUtils.wrapLine(ArgsMessages.INFO_USAGE_OPTIONS_TRAILING.get(this.commandName, this.trailingArgsPlaceholder), maxWidth));
            }
            lines.add("");
            lines.add(ArgsMessages.INFO_USAGE_OPTIONS_INCLUDE.get());
            boolean hasRequired = false;
            LinkedHashMap<String, ArrayList<Argument>> argumentsByGroup = new LinkedHashMap<String, ArrayList<Argument>>(10);
            ArrayList<Argument> argumentsWithoutGroup = new ArrayList<Argument>(this.namedArgs.size());
            ArrayList<Argument> usageArguments = new ArrayList<Argument>(this.namedArgs.size());
            for (Argument argument : this.namedArgs) {
                String argumentGroup;
                if (argument.isHidden()) continue;
                if (argument.isRequired() && !argument.hasDefaultValue()) {
                    hasRequired = true;
                }
                if ((argumentGroup = argument.getArgumentGroupName()) == null) {
                    if (argument.isUsageArgument()) {
                        usageArguments.add(argument);
                        continue;
                    }
                    argumentsWithoutGroup.add(argument);
                    continue;
                }
                ArrayList<Argument> groupArgs = (ArrayList<Argument>)argumentsByGroup.get(argumentGroup);
                if (groupArgs == null) {
                    groupArgs = new ArrayList<Argument>(10);
                    argumentsByGroup.put(argumentGroup, groupArgs);
                }
                groupArgs.add(argument);
            }
            for (Map.Entry entry : argumentsByGroup.entrySet()) {
                lines.add("");
                lines.add("  " + (String)entry.getKey());
                lines.add("");
                for (Argument a : (List)entry.getValue()) {
                    ArgumentParser.getArgUsage(a, lines, true, maxWidth);
                }
            }
            if (!argumentsWithoutGroup.isEmpty()) {
                if (argumentsByGroup.isEmpty()) {
                    for (Argument argument : argumentsWithoutGroup) {
                        ArgumentParser.getArgUsage(argument, lines, false, maxWidth);
                    }
                } else {
                    lines.add("");
                    lines.add("  " + ArgsMessages.INFO_USAGE_UNGROUPED_ARGS.get());
                    lines.add("");
                    for (Argument argument : argumentsWithoutGroup) {
                        ArgumentParser.getArgUsage(argument, lines, true, maxWidth);
                    }
                }
            }
            if (!usageArguments.isEmpty()) {
                if (argumentsByGroup.isEmpty()) {
                    for (Argument argument : usageArguments) {
                        ArgumentParser.getArgUsage(argument, lines, false, maxWidth);
                    }
                } else {
                    lines.add("");
                    lines.add("  " + ArgsMessages.INFO_USAGE_USAGE_ARGS.get());
                    lines.add("");
                    for (Argument argument : usageArguments) {
                        ArgumentParser.getArgUsage(argument, lines, true, maxWidth);
                    }
                }
            }
            if (hasRequired) {
                lines.add("");
                if (argumentsByGroup.isEmpty()) {
                    lines.add("* " + ArgsMessages.INFO_USAGE_ARG_IS_REQUIRED.get());
                } else {
                    lines.add("  * " + ArgsMessages.INFO_USAGE_ARG_IS_REQUIRED.get());
                }
            }
        }
        return lines;
    }

    private static void getArgUsage(Argument a, List<String> lines, boolean indent, int maxWidth) {
        StringBuilder argLine = new StringBuilder();
        if (indent && maxWidth > 10) {
            if (a.isRequired() && !a.hasDefaultValue()) {
                argLine.append("  * ");
            } else {
                argLine.append("    ");
            }
        } else if (a.isRequired() && !a.hasDefaultValue()) {
            argLine.append("* ");
        }
        boolean first = true;
        for (Character c : a.getShortIdentifiers()) {
            if (first) {
                argLine.append('-');
                first = false;
            } else {
                argLine.append(", -");
            }
            argLine.append(c);
        }
        for (String s : a.getLongIdentifiers()) {
            if (first) {
                argLine.append("--");
                first = false;
            } else {
                argLine.append(", --");
            }
            argLine.append(s);
        }
        String valuePlaceholder = a.getValuePlaceholder();
        if (valuePlaceholder != null) {
            argLine.append(' ');
            argLine.append(valuePlaceholder);
        }
        lines.add(argLine.toString());
        String description = a.getDescription();
        if (maxWidth > 10) {
            String indentString = indent ? "        " : "    ";
            List<String> descLines = StaticUtils.wrapLine(description, maxWidth - indentString.length());
            for (String s : descLines) {
                lines.add(indentString + s);
            }
        } else {
            lines.addAll(StaticUtils.wrapLine(description, maxWidth));
        }
    }

    public void getUsage(OutputStream outputStream, int maxWidth) throws IOException {
        List<String> usageLines = this.getUsage(maxWidth);
        for (String s : usageLines) {
            outputStream.write(StaticUtils.getBytes(s));
            outputStream.write(StaticUtils.EOL_BYTES);
        }
    }

    public String getUsageString(int maxWidth) {
        StringBuilder buffer = new StringBuilder();
        this.getUsageString(buffer, maxWidth);
        return buffer.toString();
    }

    public void getUsageString(StringBuilder buffer, int maxWidth) {
        for (String line : this.getUsage(maxWidth)) {
            buffer.append(line);
            buffer.append(StaticUtils.EOL);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ArgumentParser(commandName='");
        buffer.append(this.commandName);
        buffer.append("', commandDescription='");
        buffer.append(this.commandDescription);
        buffer.append("', minTrailingArgs=");
        buffer.append(this.minTrailingArgs);
        buffer.append("', maxTrailingArgs=");
        buffer.append(this.maxTrailingArgs);
        if (this.trailingArgsPlaceholder != null) {
            buffer.append(", trailingArgsPlaceholder='");
            buffer.append(this.trailingArgsPlaceholder);
            buffer.append('\'');
        }
        buffer.append("namedArgs={");
        Iterator<Argument> iterator = this.namedArgs.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

