/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.validation.base;

import com.jfoenix.controls.JFXTooltip;
import com.jfoenix.validation.base.ValidatorBase$$Lambda$1;
import com.jfoenix.validation.base.ValidatorBase$$Lambda$2;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Tooltip;

public abstract class ValidatorBase {
    public static final PseudoClass PSEUDO_CLASS_ERROR = PseudoClass.getPseudoClass((String)"error");
    private static final String TOOLTIP_PROP_KEY = "javafx.scene.control.Tooltip";
    public static final String ERROR_TOOLTIP_STYLE_CLASS = "error-tooltip";
    private static final String TEMP_TOOLTIP_KEY = "stashed-tootlip";
    private static final Set<String> supportedTooltipKeys = new HashSet<String>(Arrays.asList("javafx.scene.control.Tooltip", "jfoenix-tooltip"));
    protected SimpleObjectProperty<Node> srcControl = new SimpleObjectProperty();
    protected ReadOnlyBooleanWrapper hasErrors = new ReadOnlyBooleanWrapper(false);
    private Supplier<Tooltip> errorTooltipSupplier = ValidatorBase$$Lambda$1.lambdaFactory$();
    protected SimpleStringProperty message = new SimpleStringProperty();
    protected SimpleObjectProperty<Supplier<Node>> iconSupplier = new SimpleObjectProperty();

    public ValidatorBase(String message) {
        this();
        this.setMessage(message);
    }

    public ValidatorBase() {
    }

    public void validate() {
        this.eval();
        this.onEval();
    }

    protected abstract void eval();

    protected void onEval() {
        Node control = this.getSrcControl();
        boolean invalid = this.hasErrors.get();
        control.pseudoClassStateChanged(PSEUDO_CLASS_ERROR, invalid);
        Tooltip activeTooltip = this.getActiveTooltip(control);
        if (invalid) {
            Tooltip errorTooltip = this.errorTooltipSupplier.get();
            errorTooltip.getStyleClass().add((Object)ERROR_TOOLTIP_STYLE_CLASS);
            errorTooltip.setText(this.getMessage());
            this.install(control, activeTooltip, errorTooltip);
        } else {
            Tooltip orgTooltip = (Tooltip)control.getProperties().remove((Object)TEMP_TOOLTIP_KEY);
            this.install(control, activeTooltip, orgTooltip);
        }
    }

    private final Tooltip getActiveTooltip(Node node) {
        Tooltip tooltip = null;
        for (String key : supportedTooltipKeys) {
            tooltip = (Tooltip)node.getProperties().get((Object)key);
            if (tooltip == null) continue;
            break;
        }
        return tooltip;
    }

    private void install(Node node, Tooltip oldVal, Tooltip newVal) {
        if (oldVal != null && !oldVal.getStyleClass().contains((Object)ERROR_TOOLTIP_STYLE_CLASS)) {
            node.getProperties().put((Object)TEMP_TOOLTIP_KEY, (Object)oldVal);
        }
        if (node instanceof Control) {
            if (oldVal != null) {
                if (oldVal instanceof JFXTooltip) {
                    JFXTooltip.uninstall(node);
                }
                if (newVal == null || !(newVal instanceof JFXTooltip)) {
                    ((Control)node).setTooltip(newVal);
                    return;
                }
                if (newVal instanceof JFXTooltip) {
                    ((Control)node).setTooltip(null);
                }
            }
            if (newVal instanceof JFXTooltip) {
                this.install(node, newVal);
            } else {
                ((Control)node).setTooltip(newVal);
            }
        } else {
            this.uninstall(node, oldVal);
            this.install(node, newVal);
        }
    }

    private void uninstall(Node node, Tooltip tooltip) {
        if (tooltip instanceof JFXTooltip) {
            JFXTooltip.uninstall(node);
        } else {
            Tooltip.uninstall((Node)node, (Tooltip)tooltip);
        }
    }

    private void install(Node node, Tooltip tooltip) {
        if (tooltip == null) {
            return;
        }
        if (tooltip instanceof JFXTooltip) {
            JFXTooltip.install(node, (JFXTooltip)tooltip);
        } else {
            Tooltip.install((Node)node, (Tooltip)tooltip);
        }
    }

    public void setSrcControl(Node srcControl) {
        this.srcControl.set((Object)srcControl);
    }

    public Node getSrcControl() {
        return (Node)this.srcControl.get();
    }

    public ObjectProperty<Node> srcControlProperty() {
        return this.srcControl;
    }

    public boolean getHasErrors() {
        return this.hasErrors.get();
    }

    public ReadOnlyBooleanProperty hasErrorsProperty() {
        return this.hasErrors.getReadOnlyProperty();
    }

    public Supplier<Tooltip> getErrorTooltipSupplier() {
        return this.errorTooltipSupplier;
    }

    public void setErrorTooltipSupplier(Supplier<Tooltip> errorTooltipSupplier) {
        this.errorTooltipSupplier = errorTooltipSupplier;
    }

    public void setMessage(String msg) {
        this.message.set(msg);
    }

    public String getMessage() {
        return this.message.get();
    }

    public StringProperty messageProperty() {
        return this.message;
    }

    public void setIconSupplier(Supplier<Node> icon) {
        this.iconSupplier.set(icon);
    }

    public SimpleObjectProperty<Supplier<Node>> iconSupplierProperty() {
        return this.iconSupplier;
    }

    public Supplier<Node> getIconSupplier() {
        return (Supplier)this.iconSupplier.get();
    }

    public void setIcon(Node icon) {
        this.iconSupplier.set((Object)ValidatorBase$$Lambda$2.lambdaFactory$(icon));
    }

    public Node getIcon() {
        if (this.iconSupplier.get() == null) {
            return null;
        }
        Node icon = (Node)((Supplier)this.iconSupplier.get()).get();
        if (icon != null) {
            icon.getStyleClass().add((Object)"error-icon");
        }
        return icon;
    }

    static /* synthetic */ Node lambda$setIcon$1(Node icon) {
        return icon;
    }

    static /* synthetic */ Tooltip lambda$new$0() {
        return new Tooltip();
    }
}

