/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.utils;

import com.jfoenix.utils.JFXHighlighter$$Lambda$1;
import com.jfoenix.utils.JFXHighlighter$$Lambda$2;
import com.jfoenix.utils.JFXHighlighter$HighLightRectangle$$Lambda$1;
import com.jfoenix.utils.JFXHighlighter$HighLightRectangle$$Lambda$2;
import com.jfoenix.utils.JFXUtilities;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLine;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.effect.BlendMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class JFXHighlighter {
    private Parent parent;
    private HashMap<Node, List<Rectangle>> boxes = new HashMap();
    private ObjectProperty<Paint> paint = new SimpleObjectProperty((Object)Color.rgb((int)255, (int)0, (int)0, (double)0.4));
    private Method textLayoutMethod;
    private Field parentChildrenField;

    public JFXHighlighter() {
        try {
            this.textLayoutMethod = Text.class.getDeclaredMethod("getTextLayout", new Class[0]);
            this.textLayoutMethod.setAccessible(true);
            this.parentChildrenField = Parent.class.getDeclaredField("children");
            this.parentChildrenField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void highlight(Parent pane, String query) {
        if (this.parent != null && !this.boxes.isEmpty()) {
            this.clear();
        }
        if (query == null || query.isEmpty()) {
            return;
        }
        this.parent = pane;
        Set<Node> nodes = this.getTextNodes(pane);
        ArrayList<HighLightRectangle> allRectangles = new ArrayList<HighLightRectangle>();
        for (Node node : nodes) {
            Text text = (Text)node;
            int beginIndex = text.getText().toLowerCase().indexOf(query.toLowerCase());
            if (beginIndex <= -1 || !node.impl_isTreeVisible()) continue;
            ArrayList<Bounds> boundingBoxes = this.getMatchingBounds(query, text);
            ArrayList<HighLightRectangle> rectangles = new ArrayList<HighLightRectangle>();
            for (Bounds boundingBox : boundingBoxes) {
                HighLightRectangle rect = new HighLightRectangle(text);
                rect.setCacheHint(CacheHint.SPEED);
                rect.setCache(true);
                rect.setMouseTransparent(true);
                rect.setBlendMode(BlendMode.MULTIPLY);
                rect.fillProperty().bind(this.paintProperty());
                rect.setManaged(false);
                rect.setX(boundingBox.getMinX());
                rect.setY(boundingBox.getMinY());
                rect.setWidth(boundingBox.getWidth());
                rect.setHeight(boundingBox.getHeight());
                rectangles.add(rect);
                allRectangles.add(rect);
            }
            this.boxes.put(node, rectangles);
        }
        JFXUtilities.runInFXAndWait(JFXHighlighter$$Lambda$1.lambdaFactory$(this, pane, allRectangles));
    }

    private Set<Node> getTextNodes(Parent pane) {
        Set labeledTextNodes = pane.lookupAll("LabeledText");
        Set textNodes = pane.lookupAll("Text");
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.addAll(labeledTextNodes);
        nodes.addAll(textNodes);
        return nodes;
    }

    private ObservableList<Node> getParentChildren(Parent parent) {
        try {
            return (ObservableList)this.parentChildrenField.get(parent);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ArrayList<Bounds> getMatchingBounds(String query, Text text) {
        Bounds textBounds = this.parent.sceneToLocal(text.localToScene(text.getBoundsInLocal()));
        ArrayList<Bounds> rectBounds = new ArrayList<Bounds>();
        TextLayout textLayout = null;
        try {
            textLayout = (TextLayout)this.textLayoutMethod.invoke((Object)text, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        int queryLength = query.length();
        TextLine[] lines = textLayout.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String queryLow;
            TextLine line = lines[i];
            String lineText = text.getText().substring(line.getStart(), line.getStart() + line.getLength());
            String lineTextLow = lineText.toLowerCase();
            int beginIndex = lineTextLow.indexOf(queryLow = query.toLowerCase());
            if (beginIndex == -1) continue;
            RectBounds lineBounds = line.getBounds();
            double height = Math.round(lineBounds.getMaxY()) - Math.round(lineBounds.getMinY());
            double startY = height * (double)i;
            while (beginIndex != -1) {
                Text temp = new Text(lineText.substring(beginIndex, beginIndex + queryLength));
                temp.setFont(text.getFont());
                temp.applyCss();
                double width = temp.getLayoutBounds().getWidth();
                temp.setText(lineText.substring(0, beginIndex + queryLength));
                temp.applyCss();
                double maxX = temp.getLayoutBounds().getMaxX();
                double startX = maxX - width;
                rectBounds.add((Bounds)new BoundingBox(textBounds.getMinX() + startX, textBounds.getMinY() + startY, width, temp.getLayoutBounds().getHeight()));
                beginIndex = lineTextLow.indexOf(queryLow, beginIndex + queryLength);
            }
        }
        return rectBounds;
    }

    public synchronized void clear() {
        ArrayList<Rectangle> flatBoxes = new ArrayList<Rectangle>();
        Collection<List<Rectangle>> boxesCollection = this.boxes.values();
        for (List<Rectangle> box : boxesCollection) {
            flatBoxes.addAll(box);
        }
        this.boxes.clear();
        if (this.parent != null) {
            JFXUtilities.runInFXAndWait(JFXHighlighter$$Lambda$2.lambdaFactory$(this, flatBoxes));
        }
    }

    public Paint getPaint() {
        return (Paint)this.paint.get();
    }

    public ObjectProperty<Paint> paintProperty() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint.set((Object)paint);
    }

    static /* synthetic */ void lambda$clear$1(JFXHighlighter this_, List flatBoxes) {
        this_.getParentChildren(this_.parent).removeAll((Collection)flatBoxes);
    }

    static /* synthetic */ void lambda$highlight$0(JFXHighlighter this_, Parent pane, ArrayList allRectangles) {
        this_.getParentChildren(pane).addAll((Collection)allRectangles);
    }

    private class HighLightRectangle
    extends Rectangle {
        private InvalidationListener listener;

        public HighLightRectangle(Text text) {
            this.listener = JFXHighlighter$HighLightRectangle$$Lambda$1.lambdaFactory$(this, text);
            text.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
            text.localToSceneTransformProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
        }

        private void clear(Text text) {
            List rectangles = (List)JFXHighlighter.this.boxes.get(text);
            if (rectangles != null && !rectangles.isEmpty()) {
                Platform.runLater((Runnable)JFXHighlighter$HighLightRectangle$$Lambda$2.lambdaFactory$(this, rectangles));
            }
        }

        static /* synthetic */ void lambda$clear$1(HighLightRectangle this_, List rectangles) {
            this_.JFXHighlighter.this.getParentChildren(this_.JFXHighlighter.this.parent).removeAll((Collection)rectangles);
        }

        static /* synthetic */ void lambda$new$0(HighLightRectangle this_, Text text, Observable observable) {
            this_.clear(text);
        }
    }
}

