/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.svg;

import com.jfoenix.svg.SVGGlyph$$Lambda$1;
import com.jfoenix.svg.SVGGlyph$$Lambda$2;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;

public class SVGGlyph
extends Pane {
    private static final String DEFAULT_STYLE_CLASS = "jfx-svg-glyph";
    private final int glyphId;
    private final String name;
    private static final int DEFAULT_PREF_SIZE = 64;
    private double widthHeightRatio = 1.0;
    private ObjectProperty<Paint> fill = new SimpleObjectProperty();
    private StyleableDoubleProperty size = new SimpleStyleableDoubleProperty(StyleableProperties.access$000(), (Object)this, "size", -1.0){

        public void invalidated() {
            SVGGlyph.this.setSizeRatio(SVGGlyph.this.getSize());
        }
    };

    public SVGGlyph() {
        this(null);
    }

    public SVGGlyph(@NamedArg(value="svgPathContent") String svgPathContent) {
        this(-1, "UNNAMED", svgPathContent, (Paint)Color.BLACK);
    }

    public SVGGlyph(@NamedArg(value="svgPathContent") String svgPathContent, @NamedArg(value="fill") Paint fill) {
        this(-1, "UNNAMED", svgPathContent, fill);
    }

    public SVGGlyph(int glyphId, String name, String svgPathContent, Paint fill) {
        this.glyphId = glyphId;
        this.name = name;
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.fill.addListener(SVGGlyph$$Lambda$1.lambdaFactory$(this));
        this.shapeProperty().addListener(SVGGlyph$$Lambda$2.lambdaFactory$(this));
        if (svgPathContent != null && !svgPathContent.isEmpty()) {
            SVGPath shape = new SVGPath();
            shape.setContent(svgPathContent);
            this.setShape((Shape)shape);
            this.setFill(fill);
        }
        this.setPrefSize(64.0, 64.0);
    }

    public int getGlyphId() {
        return this.glyphId;
    }

    public String getName() {
        return this.name;
    }

    public void setFill(Paint fill) {
        this.fill.setValue((Object)fill);
    }

    public ObjectProperty<Paint> fillProperty() {
        return this.fill;
    }

    public Paint getFill() {
        return (Paint)this.fill.getValue();
    }

    public void setSize(double width, double height) {
        this.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.setPrefSize(width, height);
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    private void setSizeRatio(double size) {
        double width = this.widthHeightRatio * size;
        double height = size / this.widthHeightRatio;
        if (width <= size) {
            this.setSize(width, size);
        } else if (height <= size) {
            this.setSize(size, height);
        } else {
            this.setSize(size, size);
        }
    }

    public void setSizeForWidth(double width) {
        double height = width / this.widthHeightRatio;
        this.setSize(width, height);
    }

    public void setSizeForHeight(double height) {
        double width = height * this.widthHeightRatio;
        this.setSize(width, height);
    }

    public double getSize() {
        return this.size.get();
    }

    public DoubleProperty sizeProperty() {
        return this.size;
    }

    public void setSize(double size) {
        this.size.set(size);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return SVGGlyph.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    static /* synthetic */ void lambda$new$1(SVGGlyph this_, Observable observable) {
        Shape shape = this_.getShape();
        if (this_.getShape() != null) {
            this_.widthHeightRatio = shape.prefWidth(-1.0) / shape.prefHeight(-1.0);
            if (this_.getSize() != -1.0) {
                this_.setSizeRatio(this_.getSize());
            }
        }
    }

    static /* synthetic */ void lambda$new$0(SVGGlyph this_, Observable observable) {
        this_.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)(this_.getFill() == null ? Color.BLACK : this_.getFill()), null, null)}));
    }

    private static class StyleableProperties {
        private static final CssMetaData<SVGGlyph, Number> SIZE = new CssMetaData<SVGGlyph, Number>("-jfx-size", SizeConverter.getInstance(), (Number)-1.0){

            public boolean isSettable(SVGGlyph control) {
                return control.size == null || !control.size.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(SVGGlyph control) {
                return control.size;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return SIZE;
        }

        static {
            ArrayList styleables = new ArrayList(Pane.getClassCssMetaData());
            Collections.addAll(styleables, SIZE);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

