/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.skins.JFXCheckBoxSkin$$Lambda$1;
import com.jfoenix.skins.JFXCheckBoxSkin$$Lambda$2;
import com.jfoenix.skins.JFXCheckBoxSkin$$Lambda$3;
import com.jfoenix.skins.JFXCheckBoxSkin$$Lambda$4;
import com.jfoenix.transitions.CachedTransition;
import com.jfoenix.transitions.JFXFillTransition;
import com.jfoenix.utils.JFXNodeUtils;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class JFXCheckBoxSkin
extends LabeledSkinBase<JFXCheckBox, ButtonBehavior<JFXCheckBox>> {
    private final StackPane box = new StackPane();
    private final StackPane mark = new StackPane();
    private final StackPane indeterminateMark = new StackPane();
    private final JFXRippler rippler;
    private Transition transition;
    private Transition indeterminateTransition;
    private boolean invalid = true;
    private JFXFillTransition select;
    private final StackPane boxContainer;

    public JFXCheckBoxSkin(JFXCheckBox control) {
        super((Labeled)control, (BehaviorBase)new ButtonBehavior((ButtonBase)control));
        this.indeterminateMark.getStyleClass().setAll((Object[])new String[]{"indeterminate-mark"});
        this.indeterminateMark.setOpacity(0.0);
        this.indeterminateMark.setScaleX(0.0);
        this.indeterminateMark.setScaleY(0.0);
        this.mark.getStyleClass().setAll((Object[])new String[]{"mark"});
        this.mark.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        this.mark.setOpacity(0.0);
        this.mark.setScaleX(0.0);
        this.mark.setScaleY(0.0);
        this.box.getStyleClass().setAll((Object[])new String[]{"box"});
        this.box.setBorder(new Border(new BorderStroke[]{new BorderStroke(control.getUnCheckedColor(), BorderStrokeStyle.SOLID, new CornerRadii(2.0), new BorderWidths(2.0))}));
        this.box.getChildren().setAll((Object[])new Node[]{this.indeterminateMark, this.mark});
        this.boxContainer = new StackPane();
        this.boxContainer.getChildren().add((Object)this.box);
        this.boxContainer.getStyleClass().add((Object)"box-container");
        this.rippler = new JFXRippler((Node)this.boxContainer, JFXRippler.RipplerMask.CIRCLE, JFXRippler.RipplerPos.BACK);
        this.updateRippleColor();
        control.selectedProperty().addListener(JFXCheckBoxSkin$$Lambda$1.lambdaFactory$(this, control));
        control.indeterminateProperty().addListener(JFXCheckBoxSkin$$Lambda$2.lambdaFactory$(this, control));
        control.focusedProperty().addListener(JFXCheckBoxSkin$$Lambda$3.lambdaFactory$(this, control));
        control.pressedProperty().addListener(JFXCheckBoxSkin$$Lambda$4.lambdaFactory$(this));
        this.updateChildren();
        this.transition = new CheckBoxTransition((Node)this.mark);
        this.indeterminateTransition = new CheckBoxTransition((Node)this.indeterminateMark);
        this.createFillTransition();
        this.registerChangeListener((ObservableValue)control.checkedColorProperty(), "CHECKED_COLOR");
        this.registerChangeListener((ObservableValue)control.unCheckedColorProperty(), "UNCHECKED_COLOR");
    }

    private void updateRippleColor() {
        this.rippler.setRipplerFill(((JFXCheckBox)this.getSkinnable()).isSelected() ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : ((JFXCheckBox)this.getSkinnable()).getUnCheckedColor());
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("CHECKED_COLOR".equals(p)) {
            this.select.stop();
            this.createFillTransition();
            this.updateColors();
        } else if ("UNCHECKED_COLOR".equals(p)) {
            this.updateColors();
        }
    }

    private void updateColors() {
        Paint color = ((JFXCheckBox)this.getSkinnable()).isSelected() ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : ((JFXCheckBox)this.getSkinnable()).getUnCheckedColor();
        JFXNodeUtils.updateBackground(this.indeterminateMark.getBackground(), (Region)this.indeterminateMark, ((JFXCheckBox)this.getSkinnable()).getCheckedColor());
        JFXNodeUtils.updateBackground(this.box.getBackground(), (Region)this.box, (Paint)(((JFXCheckBox)this.getSkinnable()).isSelected() ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : Color.TRANSPARENT));
        this.rippler.setRipplerFill(color);
        BorderStroke borderStroke = (BorderStroke)this.box.getBorder().getStrokes().get(0);
        this.box.setBorder(new Border(new BorderStroke[]{new BorderStroke(color, borderStroke.getTopStyle(), borderStroke.getRadii(), borderStroke.getWidths())}));
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.rippler != null) {
            this.getChildren().add((Object)this.rippler);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.box.minWidth(-1.0)) + this.getLabelOffset();
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset) + this.snapSize(this.box.prefWidth(-1.0)) + this.getLabelOffset();
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(super.computeMinHeight(width - this.box.minWidth(-1.0), topInset, rightInset, bottomInset, leftInset), topInset + this.box.minHeight(-1.0) + bottomInset);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(super.computePrefHeight(width - this.box.prefWidth(-1.0), topInset, rightInset, bottomInset, leftInset), topInset + this.box.prefHeight(-1.0) + bottomInset);
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        double labelOffset = this.getLabelOffset();
        CheckBox checkBox = (CheckBox)this.getSkinnable();
        double boxWidth = this.snapSize(this.box.prefWidth(-1.0));
        double boxHeight = this.snapSize(this.box.prefHeight(-1.0));
        double computeWidth = Math.max(checkBox.prefWidth(-1.0), checkBox.minWidth(-1.0));
        double labelWidth = Math.min(computeWidth - boxWidth, w - this.snapSize(boxWidth)) + labelOffset;
        double labelHeight = Math.min(checkBox.prefHeight(labelWidth), h);
        double maxHeight = Math.max(boxHeight, labelHeight);
        double xOffset = JFXCheckBoxSkin.computeXOffset(w, labelWidth + boxWidth, checkBox.getAlignment().getHpos()) + x;
        double yOffset = JFXCheckBoxSkin.computeYOffset(h, maxHeight, checkBox.getAlignment().getVpos()) + x;
        if (this.invalid) {
            if (checkBox.isIndeterminate()) {
                this.playIndeterminateAnimation(true, false);
            } else if (checkBox.isSelected()) {
                this.playSelectAnimation(true, false);
            }
            this.invalid = false;
        }
        this.layoutLabelInArea(xOffset + boxWidth + labelOffset, yOffset, labelWidth, maxHeight, checkBox.getAlignment());
        this.rippler.resize(boxWidth, boxHeight);
        this.positionInArea((Node)this.rippler, xOffset, yOffset, boxWidth, maxHeight, 0.0, checkBox.getAlignment().getHpos(), checkBox.getAlignment().getVpos());
    }

    private double getLabelOffset() {
        return 0.2 * this.boxContainer.snappedRightInset();
    }

    static double computeXOffset(double width, double contentWidth, HPos hpos) {
        switch (hpos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (width - contentWidth) / 2.0;
            }
            case RIGHT: {
                return width - contentWidth;
            }
        }
        return 0.0;
    }

    static double computeYOffset(double height, double contentHeight, VPos vpos) {
        switch (vpos) {
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (height - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return height - contentHeight;
            }
        }
        return 0.0;
    }

    private void playSelectAnimation(Boolean selection, boolean playAnimation) {
        if (selection == null) {
            selection = false;
        }
        this.transition.setRate(selection != false ? 1.0 : -1.0);
        this.select.setRate(selection != false ? 1.0 : -1.0);
        if (playAnimation) {
            this.transition.play();
            this.select.play();
        } else {
            Insets insets;
            CornerRadii radii = this.box.getBackground() == null ? null : ((BackgroundFill)this.box.getBackground().getFills().get(0)).getRadii();
            Insets insets2 = insets = this.box.getBackground() == null ? null : ((BackgroundFill)this.box.getBackground().getFills().get(0)).getInsets();
            if (selection.booleanValue()) {
                this.mark.setScaleY(1.0);
                this.mark.setScaleX(1.0);
                this.mark.setOpacity(1.0);
                this.box.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((JFXCheckBox)this.getSkinnable()).getCheckedColor(), radii, insets)}));
                this.select.playFrom(this.select.getCycleDuration());
                this.transition.playFrom(this.transition.getCycleDuration());
            } else {
                this.mark.setScaleY(0.0);
                this.mark.setScaleX(0.0);
                this.mark.setOpacity(0.0);
                this.box.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, radii, insets)}));
                this.select.playFrom(Duration.ZERO);
                this.transition.playFrom(Duration.ZERO);
            }
        }
        this.box.setBorder(new Border(new BorderStroke[]{new BorderStroke(selection != false ? ((JFXCheckBox)this.getSkinnable()).getCheckedColor() : ((JFXCheckBox)this.getSkinnable()).getUnCheckedColor(), BorderStrokeStyle.SOLID, new CornerRadii(2.0), new BorderWidths(2.0))}));
    }

    private void playIndeterminateAnimation(Boolean indeterminate, boolean playAnimation) {
        if (indeterminate == null) {
            indeterminate = false;
        }
        this.indeterminateTransition.setRate(indeterminate != false ? 1.0 : -1.0);
        if (playAnimation) {
            this.indeterminateTransition.play();
        } else if (indeterminate.booleanValue()) {
            CornerRadii radii = this.indeterminateMark.getBackground() == null ? null : ((BackgroundFill)this.indeterminateMark.getBackground().getFills().get(0)).getRadii();
            Insets insets = this.indeterminateMark.getBackground() == null ? null : ((BackgroundFill)this.indeterminateMark.getBackground().getFills().get(0)).getInsets();
            this.indeterminateMark.setOpacity(1.0);
            this.indeterminateMark.setScaleY(1.0);
            this.indeterminateMark.setScaleX(1.0);
            this.indeterminateMark.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((JFXCheckBox)this.getSkinnable()).getCheckedColor(), radii, insets)}));
            this.indeterminateTransition.playFrom(this.indeterminateTransition.getCycleDuration());
        } else {
            this.indeterminateMark.setOpacity(0.0);
            this.indeterminateMark.setScaleY(0.0);
            this.indeterminateMark.setScaleX(0.0);
            this.indeterminateTransition.playFrom(Duration.ZERO);
        }
        if (((JFXCheckBox)this.getSkinnable()).isSelected()) {
            this.playSelectAnimation(indeterminate == false, playAnimation);
        }
    }

    private void createFillTransition() {
        this.select = new JFXFillTransition(Duration.millis((double)120.0), (Region)this.box, Color.TRANSPARENT, (Color)((JFXCheckBox)this.getSkinnable()).getCheckedColor());
        this.select.setInterpolator(Interpolator.EASE_OUT);
    }

    static /* synthetic */ void lambda$new$3(JFXCheckBoxSkin this_, ObservableValue o, Boolean oldVal, Boolean newVal) {
        this_.rippler.setOverlayVisible(false);
    }

    static /* synthetic */ void lambda$new$2(JFXCheckBoxSkin this_, JFXCheckBox control, ObservableValue o, Boolean oldVal, Boolean newVal) {
        if (!control.isDisableVisualFocus().booleanValue()) {
            if (newVal.booleanValue()) {
                if (!((JFXCheckBox)this_.getSkinnable()).isPressed()) {
                    this_.rippler.setOverlayVisible(true);
                }
            } else {
                this_.rippler.setOverlayVisible(false);
            }
        }
    }

    static /* synthetic */ void lambda$new$1(JFXCheckBoxSkin this_, JFXCheckBox control, Observable observable) {
        this_.updateRippleColor();
        this_.playIndeterminateAnimation(control.isIndeterminate(), true);
    }

    static /* synthetic */ void lambda$new$0(JFXCheckBoxSkin this_, JFXCheckBox control, Observable observable) {
        this_.updateRippleColor();
        this_.playSelectAnimation(control.isSelected(), true);
    }

    private static final class CheckBoxTransition
    extends CachedTransition {
        protected Node mark;

        CheckBoxTransition(Node mark) {
            super(null, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)mark.opacityProperty(), (Object)0, Interpolator.EASE_OUT), new KeyValue((WritableValue)mark.scaleXProperty(), (Object)0.5, Interpolator.EASE_OUT), new KeyValue((WritableValue)mark.scaleYProperty(), (Object)0.5, Interpolator.EASE_OUT)}), new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{new KeyValue((WritableValue)mark.opacityProperty(), (Object)1, Interpolator.EASE_OUT), new KeyValue((WritableValue)mark.scaleXProperty(), (Object)0.5, Interpolator.EASE_OUT), new KeyValue((WritableValue)mark.scaleYProperty(), (Object)0.5, Interpolator.EASE_OUT)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)mark.scaleXProperty(), (Object)1, Interpolator.EASE_OUT), new KeyValue((WritableValue)mark.scaleYProperty(), (Object)1, Interpolator.EASE_OUT)})}));
            this.setCycleDuration(Duration.seconds((double)0.12));
            this.setDelay(Duration.seconds((double)0.05));
            this.mark = mark;
        }

        @Override
        protected void starting() {
            super.starting();
        }

        @Override
        protected void stopping() {
            super.stopping();
            this.mark.setOpacity(this.getRate() == 1.0 ? 1.0 : 0.0);
        }
    }
}

