/*
 * Decompiled with CFR 0.152.
 */
package com.drops.poc;

import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.drops.entity.ControllersFactory;
import com.drops.poc.EurekaXstreamRCEPOC;
import com.drops.poc.H2DatabaseConsoleJNDIRCEPOC;
import com.drops.poc.JolokiaLogbackRCEPOC;
import com.drops.poc.JolokiaRealmJNDIRCEPOC;
import com.drops.poc.SnakeYAMLRCEPOC;
import com.drops.poc.SpringBootInfo;
import com.drops.poc.SpringBootUtil;
import com.drops.ui.MainController;
import com.drops.utils.HTTPUtils;
import com.drops.utils.PropertiesBean;
import com.drops.utils.ResponseUtil;
import com.drops.utils.URLUtil;
import com.drops.utils.Utils;
import java.util.Scanner;
import java.util.UUID;

public class SpringBootInfoCheck {
    public String url;
    public String method;
    private MainController mainController;
    private static final String DefalutEncoding = "UTF-8";
    public static SpringBootInfo info = new SpringBootInfo();
    public boolean SpringbootVersionV1 = false;
    private SpringBootUtil SpringbootUtils = new SpringBootUtil();

    public boolean isSpringbootVersionV1() {
        return this.SpringbootVersionV1;
    }

    public void setSpringbootVersionV1(boolean springbootVersionV1) {
        this.SpringbootVersionV1 = springbootVersionV1;
    }

    public SpringBootInfoCheck() {
        this.mainController = (MainController)ControllersFactory.controllers.get(MainController.class.getSimpleName());
    }

    public boolean CheckPointInfo(String target) {
        String url = URLUtil.normalizeURL(target + "404");
        HttpResponse response = HTTPUtils.getRequest(url);
        int statscode = response.getStatus();
        String context = response.body();
        if (statscode == 404 || statscode == 403) {
            return context.contains("Whitelabel Error Page") || context.contains("There was an unexpected error");
        }
        return false;
    }

    public boolean check404(String target) {
        String url = URLUtil.normalizeURL(target) + UUID.randomUUID();
        return HTTPUtils.getRequest(url).getStatus() == 200;
    }

    public boolean checkActuatorPointV1(String target) {
        for (String point : SpringBootInfoCheck.info.pointListV1) {
            if (!this.SpringbootUtils.checkPoint(target, point)) continue;
            this.setSpringbootVersionV1(true);
        }
        return false;
    }

    public boolean checkActuatorPointV2(String target) {
        for (String point : SpringBootInfoCheck.info.pointListV2) {
            if (!this.SpringbootUtils.checkPoint(target, point)) continue;
            this.setSpringbootVersionV1(false);
        }
        return false;
    }

    void checkEnvPointV1(String addr) {
        EurekaXstreamRCEPOC xstreamRCEPOC;
        String url = URLUtil.normalizeURL(addr) + "env";
        HttpResponse response = HTTPUtils.getRequest(url);
        PropertiesBean properties = this.EnvParser(this.scannerOutput(new Scanner(ResponseUtil.getBoby(response))));
        this.parseProperties(properties);
        SnakeYAMLRCEPOC yamlrcepoc = new SnakeYAMLRCEPOC();
        if (!yamlrcepoc.hasSnakeYAMLRCE(url) && !(xstreamRCEPOC = new EurekaXstreamRCEPOC()).hasEurekaXstreamRCE(url)) {
            H2DatabaseConsoleJNDIRCEPOC h2;
            JolokiaLogbackRCEPOC logbackRCEPOC = new JolokiaLogbackRCEPOC();
            JolokiaRealmJNDIRCEPOC realmJNDIRCEPOC = new JolokiaRealmJNDIRCEPOC();
            if (logbackRCEPOC.hasJolokiaLogbackRCE(url) && !realmJNDIRCEPOC.hasJolokiaRealmJNDIRCE(url) || !(h2 = new H2DatabaseConsoleJNDIRCEPOC()).hasH2DatabaseConsoleJNDIRCE(url)) {
                // empty if block
            }
        }
    }

    void checkEnvPointV2(String addr) {
        EurekaXstreamRCEPOC xstreamRCEPOC;
        String url = addr + "actuator/env";
        HttpResponse response = HTTPUtils.getRequest(url);
        PropertiesBean properties = this.EnvParser(this.scannerOutput(new Scanner(ResponseUtil.getBoby(response))));
        this.parseProperties(properties);
        SnakeYAMLRCEPOC yamlrcepoc = new SnakeYAMLRCEPOC();
        if (!yamlrcepoc.hasSnakeYAMLRCE(url) && !(xstreamRCEPOC = new EurekaXstreamRCEPOC()).hasEurekaXstreamRCE(url)) {
            H2DatabaseConsoleJNDIRCEPOC h2;
            JolokiaLogbackRCEPOC logbackRCEPOC = new JolokiaLogbackRCEPOC();
            JolokiaRealmJNDIRCEPOC realmJNDIRCEPOC = new JolokiaRealmJNDIRCEPOC();
            if (logbackRCEPOC.hasJolokiaLogbackRCE(url) && !realmJNDIRCEPOC.hasJolokiaRealmJNDIRCE(url) || !(h2 = new H2DatabaseConsoleJNDIRCEPOC()).hasH2DatabaseConsoleJNDIRCE(url)) {
                // empty if block
            }
        }
    }

    public PropertiesBean EnvParser(String result) {
        PropertiesBean propertiesBean = new PropertiesBean();
        try {
            JSONObject jsonObject = JSON.parseObject(result);
            JSONArray propertySources = jsonObject.getJSONArray("propertySources");
            if (propertySources.size() > 0) {
                for (int i = 0; i < propertySources.size(); ++i) {
                    JSONObject properties;
                    JSONObject propertySource = propertySources.getJSONObject(i);
                    String name = (String)propertySource.get("name");
                    if ("systemProperties".equals(name)) {
                        properties = propertySource.getJSONObject("properties");
                        String jvmName = properties.getJSONObject("java.vm.name").getString("value");
                        String javaVersion = properties.getJSONObject("java.runtime.version").getString("value");
                        String userName = properties.getJSONObject("user.name").getString("value");
                        propertiesBean.setHaveInfo(true);
                        propertiesBean.setJvmName(jvmName);
                        propertiesBean.setJavaVersion(javaVersion);
                        propertiesBean.setUserName(userName);
                        continue;
                    }
                    if (!"server.ports".equals(name)) continue;
                    propertiesBean.setHaveInfo(true);
                    properties = propertySource.getJSONObject("properties");
                    String serverPort = properties.getJSONObject("local.server.port").getString("value");
                    propertiesBean.setServerPort(serverPort);
                }
            }
        }
        catch (Exception e) {
            propertiesBean.setHaveInfo(false);
        }
        return propertiesBean;
    }

    public String scannerOutput(Scanner scanner) {
        StringBuilder builder = new StringBuilder();
        while (scanner.hasNext()) {
            builder.append(scanner.nextLine()).append("\n");
        }
        return builder.toString();
    }

    void parseProperties(PropertiesBean properties) {
        if (properties.getHaveInfo().booleanValue()) {
            this.mainController.logTextArea.appendText(Utils.log("\tJVM\u4fe1\u606f:\t\t" + properties.getJvmName()));
            this.mainController.logTextArea.appendText(Utils.log("\t\u7aef\u53e3\u4fe1\u606f:\t\t" + properties.getServerPort()));
            this.mainController.logTextArea.appendText(Utils.log("\tJava\u7248\u672c:\t\t" + properties.getJavaVersion()));
            this.mainController.logTextArea.appendText(Utils.log("\t\u7528\u6237\u540d:\t\t" + properties.getUserName()));
        }
    }
}

