/*
 * Decompiled with CFR 0.152.
 */
package com.drops.poc;

import com.drops.entity.ControllersFactory;
import com.drops.poc.SpringBootInfoCheck;
import com.drops.ui.MainController;
import com.drops.utils.PropertiesBean;
import com.drops.utils.URLUtil;
import com.drops.utils.Utils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;

public class SpringBootInfo {
    List<String> pointListV1 = new ArrayList<String>();
    List<String> pointListV2 = new ArrayList<String>();
    static boolean SpringbootVersionV1 = false;
    String[] basicPoint = new String[]{"cloudfoundryapplication", "hystrix.stream"};
    MainController mainController;
    SpringBootInfoCheck infoCheck;
    public List<String> gadget = new ArrayList<String>();
    List<String> gadgetExp = new ArrayList<String>();

    public SpringBootInfo() {
        this.mainController = (MainController)ControllersFactory.controllers.get(MainController.class.getSimpleName());
        this.infoCheck = new SpringBootInfoCheck();
        this.pointListV1.add("autoconfig");
        this.pointListV1.add("heapdump");
        this.pointListV1.add("dump");
        this.pointListV1.add("mappings");
        this.pointListV1.add("auditevents");
        this.pointListV1.add("beans");
        this.pointListV1.add("health");
        this.pointListV1.add("configprops");
        this.pointListV1.add("info");
        this.pointListV1.add("loggers");
        this.pointListV1.add("threaddump");
        this.pointListV1.add("metrics");
        this.pointListV1.add("trace");
        this.pointListV1.add("env/spring.jmx.enabled");
        this.pointListV1.add("refresh");
        this.pointListV1.add("trace");
        this.pointListV1.add("jolokia");
        this.pointListV1.add("env");
        this.pointListV1.add("restart");
        this.pointListV2.add("actuator/auditevents");
        this.pointListV2.add("actuator/env");
        this.pointListV2.add("actuator/restart");
        this.pointListV2.add("actuator/refresh");
        this.pointListV2.add("actuator/beans");
        this.pointListV2.add("actuator/health");
        this.pointListV2.add("actuator/conditions");
        this.pointListV2.add("actuator/configprops");
        this.pointListV2.add("actuator/info");
        this.pointListV2.add("actuator/loggers");
        this.pointListV2.add("actuator/httptrace");
        this.pointListV2.add("actuator/threaddump");
        this.pointListV2.add("actuator/metrics");
        this.pointListV2.add("actuator/httptrace");
        this.pointListV2.add("actuator/mappings");
        this.pointListV2.add("actuator/jolokia");
        this.pointListV2.add("actuator/jolokia/list");
        this.pointListV2.add("actuator/env/spring.jmx.enabled");
        this.pointListV2.add("monitor/auditevents");
        this.pointListV2.add("monitor/beans");
        this.pointListV2.add("monitor/conditions");
        this.pointListV2.add("monitor/configprops");
        this.pointListV2.add("monitor/env");
        this.pointListV2.add("monitor/info");
        this.pointListV2.add("monitor/loggers");
        this.pointListV2.add("monitor/heapdump");
        this.pointListV2.add("monitor/threaddump");
        this.pointListV2.add("monitor/metrics");
        this.pointListV2.add("monitor/scheduledtasks");
        this.pointListV2.add("monitor/httptrace");
        this.pointListV2.add("monitor/mappings");
        this.pointListV2.add("monitor/jolokia");
        this.gadget.add("SnakeYAMLRCEPOC");
        this.gadgetExp.add("SnakeYAMLRCEEXP");
    }

    public boolean doCheck(String target) throws MalformedURLException {
        String rootaddr = URLUtil.normalizeURL(target);
        try {
            if (this.infoCheck.CheckPointInfo(rootaddr)) {
                this.mainController.logTextArea.appendText(Utils.log("\u68c0\u6d4b\u5230 Spring Boot 404 \u7279\u5f81\uff01"));
            }
            if (this.infoCheck.check404(rootaddr)) {
                this.mainController.logTextArea.appendText(Utils.log("\u9ed8\u8ba4404\u9875\u9762\u8fd4\u56de200\uff0c\u65e0\u6cd5\u51c6\u786e\u7206\u7834\uff01"));
            }
        }
        catch (Exception e) {
            this.mainController.logTextArea.appendText(Utils.log(e.getMessage()));
        }
        try {
            this.infoCheck.checkActuatorPointV1(rootaddr);
            this.infoCheck.checkEnvPointV1(rootaddr);
            if (!SpringbootVersionV1) {
                this.infoCheck.checkActuatorPointV2(rootaddr);
                this.infoCheck.checkEnvPointV2(rootaddr);
            }
            this.mainController.logTextArea.appendText(Utils.log("\u68c0\u6d4b\u6d41\u7a0b\u7ed3\u675f! "));
        }
        catch (Exception e) {
            this.mainController.logTextArea.appendText(Utils.log("\u9047\u5230\u5f02\u5e38\u9000\u51fa\uff01"));
            this.mainController.logTextArea.appendText(Utils.log(e.getMessage()));
        }
        return true;
    }

    void parseProperties(PropertiesBean properties) {
        if (properties.getHaveInfo().booleanValue()) {
            this.mainController.logTextArea.appendText(Utils.log("\tJVM\u4fe1\u606f:\t\t" + properties.getJvmName()));
            this.mainController.logTextArea.appendText(Utils.log("\t\u7aef\u53e3\u4fe1\u606f:\t\t" + properties.getServerPort()));
            this.mainController.logTextArea.appendText(Utils.log("\tJava\u7248\u672c:\t\t" + properties.getJavaVersion()));
            this.mainController.logTextArea.appendText(Utils.log("\t\u7528\u6237\u540d:\t\t" + properties.getUserName()));
        }
    }
}

