/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LdapClient {
    private String ldapUrl;
    private String ldapUserDN;
    private String ldapPwd;

    public LdapClient(String ldapUrl, String ldapUserDN, String ldapPwd) {
        this.ldapUrl = ldapUrl;
        this.ldapUserDN = ldapUserDN;
        this.ldapPwd = ldapPwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLDAPUser(String userName, String password, String uidNumber, String gidNumber) {
        LdapContext context = this.initLDAPContext();
        BasicAttributes matchAttrs = new BasicAttributes(true);
        BasicAttribute objclassSet = new BasicAttribute("objectClass");
        objclassSet.add("account");
        objclassSet.add("posixAccount");
        matchAttrs.put(objclassSet);
        matchAttrs.put(new BasicAttribute("uid", userName));
        matchAttrs.put(new BasicAttribute("cn", userName));
        matchAttrs.put(new BasicAttribute("uidNumber", uidNumber));
        matchAttrs.put(new BasicAttribute("gidNumber", gidNumber));
        matchAttrs.put(new BasicAttribute("homeDirectory", "/home/" + userName));
        matchAttrs.put(new BasicAttribute("userpassword", password));
        matchAttrs.put(new BasicAttribute("description", "LDAP user."));
        try {
            context.bind("uid=" + userName + ",ou=People,dc=asiainfo,dc=com", null, (Attributes)matchAttrs);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            this.closeLdapContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLDAPUserGroup(String groupName, String password, String gidNumber) {
        LdapContext context = this.initLDAPContext();
        BasicAttributes matchAttrs = new BasicAttributes(true);
        matchAttrs.put(new BasicAttribute("objectclass", "posixGroup"));
        matchAttrs.put(new BasicAttribute("cn", groupName));
        matchAttrs.put(new BasicAttribute("gidNumber", gidNumber));
        matchAttrs.put(new BasicAttribute("userPassword", password));
        try {
            context.bind("cn=" + groupName + ",ou=People,dc=asiainfo,dc=com", null, (Attributes)matchAttrs);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            this.closeLdapContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLDAPUser(String userName) {
        LdapContext context = this.initLDAPContext();
        try {
            context.unbind(userName);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            this.closeLdapContext(context);
        }
    }

    public void deleteLDAPUserGroup(String groupName) {
        this.deleteLDAPUser(groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLDAPUserAttribute(String userName, String attributeName, String attributeNewValue) {
        LdapContext context = this.initLDAPContext();
        ModificationItem[] mods = new ModificationItem[1];
        mods[0] = new ModificationItem(2, new BasicAttribute(attributeName, attributeNewValue));
        try {
            context.modifyAttributes(userName, mods);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            this.closeLdapContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration<SearchResult> searchLDAPUser(String userName, String filter) {
        NamingEnumeration<SearchResult> searchResults = null;
        LdapContext context = this.initLDAPContext();
        SearchControls ctrl = new SearchControls();
        ctrl.setSearchScope(2);
        try {
            searchResults = context.search(userName, filter, ctrl);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            this.closeLdapContext(context);
        }
        return searchResults;
    }

    private LdapContext initLDAPContext() {
        InitialLdapContext context = null;
        Properties mEnv = new Properties();
        mEnv.put("java.naming.authoritative", "true");
        mEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        mEnv.put("java.naming.provider.url", this.ldapUrl);
        mEnv.put("java.naming.security.authentication", "simple");
        mEnv.put("java.naming.security.principal", this.ldapUserDN);
        mEnv.put("java.naming.security.credentials", this.ldapPwd);
        try {
            context = new InitialLdapContext(mEnv, null);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return context;
    }

    private void closeLdapContext(LdapContext context) {
        try {
            context.close();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }
}

